/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.tile;

import com.teamwizardry.librarianlib.features.autoregister.TileRegister;
import com.teamwizardry.librarianlib.features.base.block.tile.TileModTickable;
import com.teamwizardry.librarianlib.features.base.block.tile.module.ModuleInventory;
import com.teamwizardry.librarianlib.features.saving.Module;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.librarianlib.features.tesr.TileRenderer;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.render.TESRMiniTurret;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityBullet;
import com.teamwizardry.shotgunsandglitter.common.items.ItemBullet;
import com.teamwizardry.shotgunsandglitter.common.items.ModItems;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.ItemStackHandler;

@TileRegister(value="mini_turret")
@TileRenderer(value=TESRMiniTurret.class)
public class TileMiniTurret
extends TileModTickable {
    @Save
    private int targetID = -1;
    @Save
    private int cooldown = 0;
    @Save
    private boolean rightBarrel = false;
    @Save
    public boolean firing = false;
    @Save
    @Nullable
    private UUID owner = null;
    @Module
    public ModuleInventory fuelInv = new ModuleInventory(new ItemStackHandler(){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (TileEntityFurnace.func_145952_a((ItemStack)stack) > 0) {
                return super.getStackLimit(slot, stack);
            }
            return 0;
        }
    });
    @Module
    public ModuleInventory inventory = new ModuleInventory(new ItemStackHandler(){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemBullet && BulletType.byOrdinal(stack.func_77952_i()) == BulletType.BASIC) {
                return super.getStackLimit(slot, stack);
            }
            return 0;
        }
    });

    public TileMiniTurret() {
        ((ItemStackHandler)this.inventory.getHandler()).setSize(1000);
        this.inventory.setSides(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN});
        this.fuelInv.setSides(EnumFacing.field_176754_o);
    }

    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
            this.func_70296_d();
        } else {
            if (!this.field_145850_b.func_175640_z(this.func_174877_v())) {
                if (this.firing) {
                    this.firing = false;
                    this.func_70296_d();
                }
                return;
            }
            boolean emptyAmmo = true;
            int fullSlot = -1;
            for (int i = 0; i < ((ItemStackHandler)this.inventory.getHandler()).getSlots(); ++i) {
                if (((ItemStackHandler)this.inventory.getHandler()).getStackInSlot(i).func_190926_b()) continue;
                emptyAmmo = false;
                fullSlot = i;
                break;
            }
            if (emptyAmmo) {
                if (this.firing) {
                    this.firing = false;
                    this.func_70296_d();
                }
                return;
            }
            List entities = this.field_145850_b.func_175644_a(EntityLivingBase.class, input -> {
                if (input == null) {
                    return false;
                }
                double dist = input.func_174818_b(this.func_174877_v());
                return !(dist > 4096.0 || dist < 16.0 || this.owner != null && this.owner.equals(input.func_110124_au()));
            });
            entities.sort(Comparator.comparingDouble(o -> o.func_174818_b(this.func_174877_v())));
            if (entities.isEmpty()) {
                boolean mark = false;
                if (this.firing) {
                    this.firing = false;
                    mark = true;
                }
                if (this.targetID != -1) {
                    this.targetID = -1;
                    mark = true;
                }
                if (mark) {
                    this.func_70296_d();
                }
                return;
            }
            boolean fueled = false;
            for (int i = 0; i < ((ItemStackHandler)this.fuelInv.getHandler()).getSlots(); ++i) {
                if (((ItemStackHandler)this.fuelInv.getHandler()).getStackInSlot(i).func_190926_b()) continue;
                ((ItemStackHandler)this.fuelInv.getHandler()).extractItem(i, 1, false);
                fueled = true;
                break;
            }
            if (!fueled) {
                if (this.firing) {
                    this.firing = false;
                    this.func_70296_d();
                }
                return;
            }
            EntityLivingBase target = (EntityLivingBase)entities.get(0);
            if (this.targetID != target.func_145782_y()) {
                this.targetID = target.func_145782_y();
                this.func_70296_d();
            }
            ItemStack ammo = ((ItemStackHandler)this.inventory.getHandler()).extractItem(fullSlot, 1, false);
            BulletEffect bulletEffect = ModItems.BULLET.getEffectFromItem(ammo);
            Vec3d normal = target.func_174791_d().func_72441_c(0.0, (double)target.func_70047_e(), 0.0).func_178788_d(new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5)).func_178787_e(new Vec3d(target.field_70159_w, 0.0, target.field_70179_y).func_72432_b()).func_72432_b();
            Vec3d position = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(normal);
            if (!this.field_145850_b.field_72995_K) {
                EntityBullet bullet = new EntityBullet(this.field_145850_b, normal, BulletType.BASIC, bulletEffect, 0.0f, 1.0f);
                bullet.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
                this.field_145850_b.func_72838_d((Entity)bullet);
            } else {
                if (bulletEffect.getFireSound() != null) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), bulletEffect.getFireSound(), SoundCategory.PLAYERS, RandUtil.nextFloat(3.0f, 4.0f), RandUtil.nextFloat(0.95f, 1.1f), false);
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (SoundEvent)ModSounds.SHOT_PISTOL, SoundCategory.PLAYERS, RandUtil.nextFloat(3.0f, 4.0f), RandUtil.nextFloat(0.95f, 1.1f), false);
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (SoundEvent)ModSounds.MAGIC_SPARKLE, SoundCategory.PLAYERS, RandUtil.nextFloat(3.0f, 4.0f), RandUtil.nextFloat(0.95f, 1.1f), false);
            }
            if (!this.firing) {
                this.firing = true;
            }
            this.cooldown = 40;
            this.rightBarrel = !this.rightBarrel;
            this.func_70296_d();
        }
    }

    public ModuleInventory getFuelInv() {
        return this.fuelInv;
    }

    public ModuleInventory getInventory() {
        return this.inventory;
    }

    public boolean isRightBarrel() {
        return this.rightBarrel;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getTargetID() {
        return this.targetID;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }
}

