/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.recipes;

import com.teamwizardry.librarianlib.core.common.RecipeGeneratorHandler;
import com.teamwizardry.librarianlib.core.common.RegistrationHandler;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.common.blocks.ModBlocks;
import com.teamwizardry.shotgunsandglitter.common.items.ItemBullet;
import com.teamwizardry.shotgunsandglitter.common.items.ItemGrenade;
import com.teamwizardry.shotgunsandglitter.common.items.ModItems;
import com.teamwizardry.shotgunsandglitter.common.recipes.RecipeAmmoHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRecipes {
    private static final Map<String, Object> BULLET_INGREDIENTS = new HashMap<String, Object>();
    private static final Map<String, Object> GRENADE_INGREDIENTS = new HashMap<String, Object>();

    public static void init() {
        RegistrationHandler.register((IForgeRegistryEntry)new RecipeAmmoHolder(ModItems.MAGAZINE), (ResourceLocation)new ResourceLocation("shotgunsandglitter", "magazine"));
        RegistrationHandler.register((IForgeRegistryEntry)new RecipeAmmoHolder(ModItems.DRUM), (ResourceLocation)new ResourceLocation("shotgunsandglitter", "drum"));
        RecipeGeneratorHandler.addShapedRecipe((String)"pistol", (ItemStack)new ItemStack((Item)ModItems.PISTOL), (Object[])new Object[]{"RL ", "RII", "  I", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron"});
        RecipeGeneratorHandler.addShapedRecipe((String)"shotgun", (ItemStack)new ItemStack((Item)ModItems.SHOTGUN), (Object[])new Object[]{"RRL", "RLI", " II", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron"});
        RecipeGeneratorHandler.addShapedRecipe((String)"sniper", (ItemStack)new ItemStack((Item)ModItems.SNIPER), (Object[])new Object[]{"RBL", " II", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron"});
        RecipeGeneratorHandler.addShapedRecipe((String)"minigun", (ItemStack)new ItemStack((Item)ModItems.MINIGUN), (Object[])new Object[]{" LI", "RBB", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron"});
        RecipeGeneratorHandler.addShapedRecipe((String)"turret", (ItemStack)new ItemStack((Item)Objects.requireNonNull(ModBlocks.MINI_TURRET.getItemForm())), (Object[])new Object[]{"RRR", "LIL", "BBB", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron"});
        RecipeGeneratorHandler.addShapedRecipe((String)"basic_bullet", (ItemStack)ItemBullet.getStackOfEffect(BulletType.BASIC, "basic", 4), (Object[])new Object[]{"IIG", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gunpowder"});
        RecipeGeneratorHandler.addShapedRecipe((String)"shotgun_bullet", (ItemStack)ItemBullet.getStackOfEffect(BulletType.SHOTGUN, "basic", 6), (Object[])new Object[]{"IG ", "IIG", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gunpowder"});
        RecipeGeneratorHandler.addShapedRecipe((String)"sniper_bullet", (ItemStack)ItemBullet.getStackOfEffect(BulletType.SNIPER, "basic", 8), (Object[])new Object[]{"IG ", "IIG", "IG ", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gunpowder"});
        RecipeGeneratorHandler.addShapedRecipe((String)"grenade", (ItemStack)ItemGrenade.getStackOfEffect("basic", 4), (Object[])new Object[]{"NSN", "IGI", "NIN", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gunpowder", Character.valueOf('N'), "nuggetIron", Character.valueOf('S'), "string"});
        for (Map.Entry<String, Object> ingredient : BULLET_INGREDIENTS.entrySet()) {
            for (BulletType type : BulletType.values()) {
                RecipeGeneratorHandler.addShapelessRecipe((String)(ingredient.getKey() + "_bullet_" + type.serializeName), (String)("sng:bullet_" + ingredient.getKey()), (ItemStack)ItemBullet.getStackOfEffect(type, ingredient.getKey()), (Object[])new Object[]{ItemBullet.getStackOfEffect(type, "basic"), ingredient.getValue()});
                RecipeGeneratorHandler.addShapedRecipe((String)(ingredient.getKey() + "_bullet_" + type.serializeName + "_8x"), (String)("sng:bullet_" + ingredient.getKey()), (ItemStack)ItemBullet.getStackOfEffect(type, ingredient.getKey(), 8), (Object[])new Object[]{"BBB", "BIB", "BBB", Character.valueOf('B'), ItemBullet.getStackOfEffect(type, "basic"), Character.valueOf('I'), ingredient.getValue()});
            }
        }
        for (Map.Entry<String, Object> ingredient : GRENADE_INGREDIENTS.entrySet()) {
            RecipeGeneratorHandler.addShapelessRecipe((String)(ingredient.getKey() + "_grenade"), (String)("sng:grenade_" + ingredient.getKey()), (ItemStack)ItemGrenade.getStackOfEffect(ingredient.getKey()), (Object[])new Object[]{ItemGrenade.getStackOfEffect("basic"), ingredient.getValue()});
            RecipeGeneratorHandler.addShapedRecipe((String)(ingredient.getKey() + "_grenade_8x"), (String)("sng:grenade_" + ingredient.getKey()), (ItemStack)ItemGrenade.getStackOfEffect(ingredient.getKey(), 8), (Object[])new Object[]{"BBB", "BIB", "BBB", Character.valueOf('B'), ItemGrenade.getStackOfEffect("basic"), Character.valueOf('I'), ingredient.getValue()});
        }
    }

    static {
        BULLET_INGREDIENTS.put("balefire", "netherStar");
        BULLET_INGREDIENTS.put("biotic", new ItemStack(Items.field_151127_ba));
        BULLET_INGREDIENTS.put("draconic", new ItemStack(Items.field_185157_bK));
        BULLET_INGREDIENTS.put("firework", "paper");
        BULLET_INGREDIENTS.put("flash", "dustGlowstone");
        BULLET_INGREDIENTS.put("frost", new ItemStack(Blocks.field_150432_aD));
        BULLET_INGREDIENTS.put("gravity_in", new ItemStack(Items.field_190930_cZ));
        BULLET_INGREDIENTS.put("gravity_out", "gunpowder");
        BULLET_INGREDIENTS.put("hookshot", new ItemStack(Items.field_151058_ca));
        BULLET_INGREDIENTS.put("impact", "obsidian");
        BULLET_INGREDIENTS.put("piercing", new ItemStack(Items.field_151032_g));
        BULLET_INGREDIENTS.put("psychic", "enderpearl");
        BULLET_INGREDIENTS.put("tainted", new ItemStack(Items.field_151070_bp));
        BULLET_INGREDIENTS.put("tranq", "dustRedstone");
        GRENADE_INGREDIENTS.put("disco", "dye");
        GRENADE_INGREDIENTS.put("blizzard", new ItemStack(Items.field_151126_ay));
        GRENADE_INGREDIENTS.put("daylight", new ItemStack(Items.field_151065_br));
        GRENADE_INGREDIENTS.put("repulsion", "gunpowder");
    }
}

