/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.items;

import com.teamwizardry.librarianlib.core.client.ModelHandler;
import com.teamwizardry.librarianlib.features.base.IExtraVariantHolder;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.EffectRegistry;
import com.teamwizardry.shotgunsandglitter.api.IBulletItem;
import com.teamwizardry.shotgunsandglitter.common.items.ModItems;
import java.util.Arrays;
import kotlin.jvm.functions.Function1;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBullet
extends ItemMod
implements IExtraVariantHolder,
IBulletItem {
    public ItemBullet() {
        super("bullet", (String[])Arrays.stream(BulletType.values()).map(type -> "bullet_" + type.serializeName).toArray(String[]::new));
    }

    public static ItemStack getStackOfEffect(BulletType type, String effect) {
        return ItemBullet.getStackOfEffect(type, effect, 1);
    }

    public static ItemStack getStackOfEffect(BulletType type, String effect, int count) {
        ItemStack stack = new ItemStack((Item)ModItems.BULLET, count, type.ordinal());
        if (!EffectRegistry.getBulletEffectByID(effect).getID().equals("basic")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"effect", (String)effect);
        }
        return stack;
    }

    @Override
    @NotNull
    public BulletType getBulletType(@NotNull ItemStack stack) {
        return BulletType.byOrdinal(stack.func_77952_i());
    }

    @NotNull
    public String[] getExtraVariants() {
        return (String[])EffectRegistry.getBulletEffects().stream().flatMap(effect -> Arrays.stream(BulletType.values()).map(bullet -> bullet.serializeName + "/" + effect.getID())).toArray(String[]::new);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Function1<ItemStack, ModelResourceLocation> getMeshDefinition() {
        return stack -> {
            BulletType type = BulletType.byOrdinal(stack.func_77952_i());
            BulletEffect bulletEffect = this.getEffectFromItem((ItemStack)stack);
            return ModelHandler.INSTANCE.getResource("shotgunsandglitter", type.serializeName + "/" + bulletEffect.getID());
        };
    }

    @Override
    @NotNull
    public BulletEffect getEffectFromItem(@NotNull ItemStack stack) {
        String effectID = ItemNBTHelper.getString((ItemStack)stack, (String)"effect", (String)"basic");
        return EffectRegistry.getBulletEffectByID(effectID);
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getEffectFromItem(stack).getID();
    }

    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        for (BulletEffect bulletEffect : EffectRegistry.getBulletEffects()) {
            for (BulletType type : BulletType.values()) {
                subItems.add((Object)ItemBullet.getStackOfEffect(type, bulletEffect.getID()));
            }
        }
    }
}

