/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.entity;

import com.teamwizardry.shotgunsandglitter.ShotgunsAndGlitter;
import com.teamwizardry.shotgunsandglitter.api.EffectRegistry;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.api.IGrenadeEntity;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityGrenade
extends EntityThrowable
implements IGrenadeEntity {
    private static final DataParameter<String> GRENADE_EFFECT = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> CASTER_ID = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityGrenade(@NotNull World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityGrenade(@NotNull World world, Vec3d normal, GrenadeEffect effect) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.setEffect(effect);
        this.setCasterId(-1);
        this.func_70186_c(normal.field_72450_a, normal.field_72448_b, normal.field_72449_c, 1.0f, 1.0f);
    }

    public EntityGrenade(@NotNull World world, @NotNull EntityLivingBase caster, GrenadeEffect effect) {
        super(world, caster);
        this.func_70105_a(0.1f, 0.1f);
        this.setEffect(effect);
        this.setCasterId(caster.func_145782_y());
        this.func_184538_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, 1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(GRENADE_EFFECT, (Object)"");
        this.field_70180_af.func_187214_a(CASTER_ID, (Object)-1);
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected void func_70184_a(@NotNull RayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = this.field_70170_p.func_180495_p(result.func_178782_a());
            if (state.func_185890_d((IBlockAccess)this.field_70170_p, result.func_178782_a()) != Block.field_185506_k && state.func_177230_c().func_176209_a(state, false)) {
                this.die(result.field_72307_f);
            }
        } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != null) {
            this.die(result.field_72307_f);
        }
    }

    public void die(Vec3d position) {
        ShotgunsAndGlitter.PROXY.grenadeImpact(this.field_70170_p, this, this.getEffect(), position);
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70173_aa >= 50) {
            if (!this.field_70170_p.field_72995_K) {
                this.die(this.func_174791_d());
            }
        } else {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)ModSounds.DUST_SPARKLE, SoundCategory.PLAYERS, RandUtil.nextFloat(0.1f, 0.3f), RandUtil.nextFloat(0.95f, 1.1f), false);
            }
            ShotgunsAndGlitter.PROXY.grenadeUpdate(this.field_70170_p, this, this.getEffect());
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("grenadeEffect", (String)this.field_70180_af.func_187225_a(GRENADE_EFFECT));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(GRENADE_EFFECT, (Object)compound.func_74779_i("grenadeEffect"));
    }

    @Override
    @NotNull
    public GrenadeEffect getEffect() {
        return EffectRegistry.getGrenadeEffectByID((String)this.field_70180_af.func_187225_a(GRENADE_EFFECT));
    }

    @Override
    public void setEffect(@NotNull GrenadeEffect effect) {
        this.field_70180_af.func_187227_b(GRENADE_EFFECT, (Object)effect.getID());
    }

    @Override
    public int getCasterId() {
        return (Integer)this.field_70180_af.func_187225_a(CASTER_ID);
    }

    @Override
    public void setCasterId(int casterId) {
        this.field_70180_af.func_187227_b(CASTER_ID, (Object)casterId);
    }

    @Override
    @NotNull
    public Entity getAsEntity() {
        return this;
    }

    @Override
    @Nullable
    public EntityLivingBase getEntityThrower() {
        return this.field_70192_c;
    }

    @Override
    @NotNull
    public Vec3d getPositionAsVector() {
        return this.func_174791_d();
    }

    @Override
    @NotNull
    public BlockPos getPositionAsBlockPos() {
        return this.func_180425_c();
    }

    @Override
    public double posX() {
        return this.field_70165_t;
    }

    @Override
    public double posY() {
        return this.field_70163_u;
    }

    @Override
    public double posZ() {
        return this.field_70161_v;
    }

    @Override
    public double motionX() {
        return this.field_70159_w;
    }

    @Override
    public double motionY() {
        return this.field_70181_x;
    }

    @Override
    public double motionZ() {
        return this.field_70179_y;
    }
}

