/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.entity;

import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDroppingBlock
extends Entity {
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityDroppingBlock.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<IBlockState>> STATE = EntityDataManager.func_187226_a(EntityDroppingBlock.class, (DataSerializer)DataSerializers.field_187197_g);
    public int fallTime = 0;
    public boolean shouldDropItem = true;
    public NBTTagCompound tileEntityData = null;

    @Nullable
    public static Entity dropBlock(@Nullable Entity shooter, @NotNull World world, @NotNull BlockPos position, Boolean dropState, boolean spawnInWorld, boolean breakBlock, boolean breakParticles) {
        IBlockState state = world.func_180495_p(position);
        if (!(shooter instanceof EntityPlayer) || !world.func_175667_e(position) || !world.func_175660_a((EntityPlayer)shooter, position) || state.func_177230_c().func_180647_a(state, (EntityPlayer)shooter, world, position) <= 0.0f || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, position, state, (EntityPlayer)shooter))) {
            return null;
        }
        if (!state.func_177230_c().func_176200_f((IBlockAccess)world, position)) {
            Object block;
            if (breakBlock) {
                world.func_175698_g(position);
                if (breakParticles) {
                    world.func_175718_b(2001, position.func_185334_h(), Block.func_176210_f((IBlockState)state));
                }
            }
            if (dropState == null) {
                block = new EntityFallingBlock(world, (double)position.func_177958_n() + 0.5, (double)((float)position.func_177956_o() + (BlockFalling.func_185759_i((IBlockState)world.func_180495_p(position.func_177977_b())) ? 0.0f : 0.01f)), (double)position.func_177952_p() + 0.5, state);
                block.field_145812_b = 1;
            } else {
                block = new EntityDroppingBlock(world, (double)position.func_177958_n() + 0.5, (float)position.func_177956_o() + (BlockFalling.func_185759_i((IBlockState)world.func_180495_p(position.func_177977_b())) ? 0.0f : 0.01f), (double)position.func_177952_p() + 0.5, state).withDrop(dropState);
            }
            if (spawnInWorld) {
                world.func_72838_d((Entity)block);
            }
            return block;
        }
        return null;
    }

    public EntityDroppingBlock(World world) {
        super(world);
    }

    public EntityDroppingBlock(World world, double x, double y, double z, IBlockState fallingBlockState) {
        super(world);
        this.setBlock(fallingBlockState);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(x, y + (double)((1.0f - this.field_70131_O) / 2.0f), z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setOrigin(new BlockPos((Entity)this));
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public void setOrigin(BlockPos origin) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)origin);
    }

    public IBlockState getBlock() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(STATE)).or((Object)Blocks.field_150350_a.func_176223_P());
    }

    public void setBlock(IBlockState state) {
        this.field_70180_af.func_187227_b(STATE, (Object)Optional.of((Object)state));
    }

    public EntityDroppingBlock withDrop(boolean should) {
        this.shouldDropItem = should;
        return this;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(STATE, (Object)Optional.absent());
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        Block block = this.getBlock().func_177230_c();
        if (this.getBlock().func_185904_a() == Material.field_151579_a) {
            this.func_70106_y();
        } else if (this.field_70167_r == this.field_70163_u && this.fallTime > 10) {
            this.die();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            ++this.fallTime;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.04;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            if (!this.field_70170_p.field_72995_K) {
                BlockPos selfPos = new BlockPos((Entity)this);
                if (this.field_70122_E) {
                    IBlockState stateInWorld = this.field_70170_p.func_180495_p(selfPos);
                    BlockPos slightlyDown = new BlockPos(this.field_70165_t, this.field_70163_u - 0.001, this.field_70161_v);
                    if (this.field_70170_p.func_175623_d(slightlyDown) && BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(slightlyDown))) {
                        this.field_70122_E = false;
                        return;
                    }
                    this.field_70159_w *= 0.7;
                    this.field_70179_y *= 0.7;
                    this.field_70181_x *= -0.5;
                    if (stateInWorld.func_177230_c() != Blocks.field_180384_M) {
                        if (block instanceof BlockFalling) {
                            ((BlockFalling)block).func_190974_b(this.field_70170_p, selfPos);
                        }
                        this.die();
                    }
                } else if (this.fallTime > 100 && (selfPos.func_177956_o() < 1 || selfPos.func_177956_o() > 256) || this.fallTime > 600) {
                    this.die();
                }
            }
        }
    }

    public void die() {
        if (!this.field_70170_p.field_72995_K) {
            Block block = this.getBlock().func_177230_c();
            if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) {
                this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.getBlock())), 0.0f);
            }
            this.field_70170_p.func_175718_b(2001, this.func_180425_c(), Block.func_176210_f((IBlockState)this.getBlock()));
        }
        this.func_70106_y();
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_184213_bq() {
        return true;
    }

    protected void func_70014_b(@NotNull NBTTagCompound compound) {
        Block block = this.getBlock().func_177230_c();
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        compound.func_74778_a("Block", resourcelocation.toString());
        compound.func_74774_a("Data", (byte)block.func_176201_c(this.getBlock()));
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74757_a("DropItem", this.shouldDropItem);
        if (this.tileEntityData != null) {
            compound.func_74782_a("TileEntityData", (NBTBase)this.tileEntityData);
        }
    }

    protected void func_70037_a(@NotNull NBTTagCompound compound) {
        int data = compound.func_74771_c("Data") & 0xFF;
        Block block = Block.func_149684_b((String)compound.func_74779_i("Block"));
        if (block == null) {
            block = Blocks.field_150350_a;
        }
        this.setBlock(block.func_176203_a(data));
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("DropItem", 99)) {
            this.shouldDropItem = compound.func_74767_n("DropItem");
        }
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = compound.func_74775_l("TileEntityData");
        }
        if (block.func_176223_P().func_185904_a() == Material.field_151579_a) {
            this.setBlock(Blocks.field_150354_m.func_176223_P());
        }
    }

    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Imitating block ID", (Object)Block.func_149682_b((Block)this.getBlock().func_177230_c()));
        category.func_71507_a("Imitating block data", (Object)this.getBlock().func_177230_c().func_176201_c(this.getBlock()));
    }
}

