/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.entity;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.shotgunsandglitter.ShotgunsAndGlitter;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletImpactEvent;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.EffectRegistry;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.network.PacketImpactSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBullet
extends EntityThrowable
implements IBulletEntity {
    private static final DataParameter<Byte> BULLET_TYPE = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<String> BULLET_EFFECT = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> CASTER_ID = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> POTENCY = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187200_j);

    public EntityBullet(@NotNull World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityBullet(@NotNull World world, Vec3d normal, @NotNull BulletType bulletType, @NotNull BulletEffect bulletEffect, float inaccuracy, float potency) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.setBulletType(bulletType);
        this.setEffect(bulletEffect);
        this.setCasterId(-1);
        this.setPotency(potency);
        this.func_70186_c(normal.field_72450_a, normal.field_72448_b, normal.field_72449_c, bulletEffect.getVelocity(world, bulletType), inaccuracy);
        this.setOrigin(this.func_180425_c());
    }

    public EntityBullet(@NotNull World world, @NotNull EntityLivingBase caster, @NotNull BulletType bulletType, @NotNull BulletEffect bulletEffect, float inaccuracy, float potency) {
        super(world, caster);
        this.func_70105_a(0.1f, 0.1f);
        this.setBulletType(bulletType);
        this.setEffect(bulletEffect);
        this.setCasterId(caster.func_145782_y());
        this.setPotency(potency);
        this.func_184538_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, bulletEffect.getVelocity(world, bulletType), inaccuracy);
        this.setOrigin(this.func_180425_c());
    }

    @Override
    @NotNull
    public Entity getAsEntity() {
        return this;
    }

    @Override
    @Nullable
    public EntityLivingBase getEntityThrower() {
        return this.field_70192_c;
    }

    @Override
    @NotNull
    public Vec3d getPositionAsVector() {
        return this.func_174791_d();
    }

    @Override
    @NotNull
    public BlockPos getPositionAsBlockPos() {
        return this.func_180425_c();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BULLET_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(BULLET_EFFECT, (Object)"");
        this.field_70180_af.func_187214_a(CASTER_ID, (Object)-1);
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(POTENCY, (Object)Float.valueOf(1.0f));
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        double mX = this.field_70159_w;
        double mY = this.field_70181_x;
        double mZ = this.field_70179_y;
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        if (!this.field_174854_a) {
            this.field_70159_w = mX;
            this.field_70181_x = mY - (double)this.getFalloff() / 100.0;
            this.field_70179_y = mZ;
        }
        if ((double)this.field_70173_aa >= 50.0) {
            this.func_70106_y();
            this.field_70170_p.func_72900_e((Entity)this);
        } else {
            if (this.field_70170_p.field_72995_K) {
                List entities = this.field_70170_p.func_175644_a(EntityPlayer.class, input -> input != null && !(input.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 25.0));
                for (EntityPlayer player : entities) {
                    if (player.func_145782_y() == this.getCasterId()) continue;
                    this.field_70170_p.func_184133_a(player, this.func_180425_c(), (SoundEvent)ModSounds.BULLET_FLYBY, SoundCategory.PLAYERS, RandUtil.nextFloat(0.9f, 1.1f), RandUtil.nextFloat(0.95f, 1.1f));
                    this.field_70170_p.func_184133_a(player, this.func_180425_c(), (SoundEvent)ModSounds.DUST_SPARKLE, SoundCategory.PLAYERS, RandUtil.nextFloat(0.1f, 0.3f), RandUtil.nextFloat(0.95f, 1.1f));
                }
            }
            ShotgunsAndGlitter.PROXY.updateBulletEntity(this.field_70170_p, this, this.getEffect());
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_70184_a(@NotNull RayTraceResult result) {
        if (MinecraftForge.EVENT_BUS.post((Event)new BulletImpactEvent(this.field_70170_p, this, result))) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = this.field_70170_p.func_180495_p(result.func_178782_a());
            if (!this.field_70170_p.field_72995_K && state.func_185890_d((IBlockAccess)this.field_70170_p, result.func_178782_a()) != Block.field_185506_k && state.func_177230_c().func_176209_a(state, false) && ShotgunsAndGlitter.PROXY.collideBulletWithBlock(this.field_70170_p, this, result.func_178782_a(), state, this.getEffect(), result.field_72307_f)) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketImpactSound(this.func_174791_d(), this.getEffect().getID()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 512.0));
                this.func_70106_y();
            }
        } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != null && !this.field_70170_p.field_72995_K && ShotgunsAndGlitter.PROXY.collideBulletWithEntity(this.field_70170_p, this, result.field_72308_g, this.getEffect(), result.field_72307_f)) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketImpactSound(this.func_174791_d(), this.getEffect().getID()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 512.0));
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("bulletType", ((Byte)this.field_70180_af.func_187225_a(BULLET_TYPE)).byteValue());
        compound.func_74778_a("bulletEffect", (String)this.field_70180_af.func_187225_a(BULLET_EFFECT));
        compound.func_74776_a("bulletPotency", this.getPotency());
        compound.func_74772_a("bulletOrigin", this.getOrigin().func_177986_g());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(BULLET_TYPE, (Object)compound.func_74771_c("bulletType"));
        this.field_70180_af.func_187227_b(BULLET_EFFECT, (Object)compound.func_74779_i("bulletEffect"));
        this.setPotency(compound.func_74760_g("bulletPotency"));
        this.setOrigin(BlockPos.func_177969_a((long)compound.func_74763_f("bulletOrigin")));
    }

    @Override
    public double posX() {
        return this.field_70165_t;
    }

    @Override
    public double posY() {
        return this.field_70163_u;
    }

    @Override
    public double posZ() {
        return this.field_70161_v;
    }

    @Override
    public double motionX() {
        return this.field_70159_w;
    }

    @Override
    public double motionY() {
        return this.field_70181_x;
    }

    @Override
    public double motionZ() {
        return this.field_70179_y;
    }

    @Override
    @NotNull
    public BulletType getBulletType() {
        return BulletType.byOrdinal(((Byte)this.field_70180_af.func_187225_a(BULLET_TYPE)).byteValue());
    }

    @Override
    public void setBulletType(@NotNull BulletType type) {
        this.field_70180_af.func_187227_b(BULLET_TYPE, (Object)((byte)type.ordinal()));
    }

    @Override
    @NotNull
    public BulletEffect getEffect() {
        return EffectRegistry.getBulletEffectByID((String)this.field_70180_af.func_187225_a(BULLET_EFFECT));
    }

    @Override
    public void setEffect(@NotNull BulletEffect bulletEffect) {
        this.field_70180_af.func_187227_b(BULLET_EFFECT, (Object)bulletEffect.getID());
    }

    @Override
    public int getCasterId() {
        return (Integer)this.field_70180_af.func_187225_a(CASTER_ID);
    }

    @Override
    public void setCasterId(int casterId) {
        this.field_70180_af.func_187227_b(CASTER_ID, (Object)casterId);
    }

    @Override
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    @Override
    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    @Override
    public float getPotency() {
        return ((Float)this.field_70180_af.func_187225_a(POTENCY)).floatValue();
    }

    @Override
    public void setPotency(float potency) {
        this.field_70180_af.func_187227_b(POTENCY, (Object)Float.valueOf(potency));
    }
}

