/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.api.IGrenadeEntity;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class GrenadeEffectRepulsion
implements GrenadeEffect {
    @Override
    public String getID() {
        return "repulsion";
    }

    @Override
    public float range(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return 15.0f;
    }

    @Override
    public void hitEntity(@NotNull World world, @NotNull IGrenadeEntity grenade, @NotNull Entity entity, float intensity) {
        if (!world.field_72995_K) {
            Vec3d repulsion = entity.func_174791_d().func_72441_c(0.0, (double)(entity.field_70131_O / 2.0f), 0.0).func_178788_d(grenade.getPositionAsVector()).func_72432_b().func_186678_a((double)(intensity * 3.0f));
            entity.field_70159_w += repulsion.field_72450_a;
            entity.field_70181_x += repulsion.field_72448_b + 0.5;
            entity.field_70179_y += repulsion.field_72449_c;
            entity.field_70133_I = true;
        }
        entity.func_70097_a(DamageSource.field_76377_j, 1.0E-6f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        Color color = Color.RED;
        Color color2 = Color.ORANGE;
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.disableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)10, (int)0, (i, build) -> {
            build.setMotion(Vec3d.field_186680_a);
            build.setLifetime(RandUtil.nextInt(10, 20));
            build.setScale(RandUtil.nextFloat(0.2f, 1.0f));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, RandUtil.nextFloat(0.5f, 1.0f)));
            double radius = RandUtil.nextDouble(0.1, 0.2);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.addMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
            if (RandUtil.nextBoolean()) {
                build.setColor(color);
            } else {
                build.setColor(color2);
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        Color color = Color.RED;
        Color color2 = Color.ORANGE;
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.03, -0.04), 0.0));
        glitter.setCanBounce(true);
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)100, (int)0, (i, build) -> {
            build.setMotion(Vec3d.field_186680_a);
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScale(RandUtil.nextFloat(0.2f, 1.0f));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, RandUtil.nextFloat(0.5f, 1.0f)));
            double radius = 3.0f * RandUtil.nextFloat();
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.addMotion(new Vec3d(x, RandUtil.nextDouble(0.0, radius), z));
            if (RandUtil.nextBoolean()) {
                build.setColor(color);
            } else {
                build.setColor(color2);
            }
        });
    }
}

