/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.api.IGrenadeEntity;
import com.teamwizardry.shotgunsandglitter.api.LingerObject;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.potions.ModPotions;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class GrenadeEffectDisco
implements GrenadeEffect {
    private float hue = 0.0f;

    @Override
    public String getID() {
        return "disco";
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        GrenadeEffect.super.onImpact(world, grenade);
        if (world.field_72995_K) {
            world.func_184134_a(grenade.posX(), grenade.posY(), grenade.posZ(), (SoundEvent)ModSounds.DISCO, SoundCategory.PLAYERS, 4.0f, 1.0f, false);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        ClientEventHandler.lingerObjects.add(new LingerObject(world, grenade.getPositionAsVector(), 200, lingering -> {
            ParticleBuilder glitter = new ParticleBuilder(10);
            glitter.setRender(ClientEventHandler.SPARKLE);
            glitter.setCollision(true);
            glitter.setCanBounce(true);
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)lingering.world, (InterpFunction)new StaticInterp((Object)lingering.pos), (int)10, (int)0, (i, build) -> {
                this.hue = this.hue >= 1.0f ? 0.0f : (float)((double)this.hue + 0.1);
                build.setLifetime(RandUtil.nextInt(20, 50));
                build.setColorFunction((InterpFunction)new InterpColorHSV(Color.getHSBColor(RandUtil.nextFloat(), 1.0f, 1.0f), Color.getHSBColor(this.hue, 1.0f, 1.0f)));
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 0.6f), 0.0f));
                build.setAcceleration(new Vec3d(0.0, -0.1, 0.0));
                double radius = 1.0f * RandUtil.nextFloat();
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double x = radius * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = radius * (double)MathHelper.func_76126_a((float)((float)theta));
                build.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-1.0, 1.0), z));
                build.setMotion(new Vec3d(x, RandUtil.nextDouble(0.0, 1.0), z));
            });
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)lingering.world, (InterpFunction)new StaticInterp((Object)lingering.pos), (int)5, (int)0, (i, build) -> {
                this.hue = this.hue >= 1.0f ? 0.0f : (float)((double)this.hue + 0.1);
                build.setLifetime(RandUtil.nextInt(50, 100));
                build.setColorFunction((InterpFunction)new InterpColorHSV(Color.getHSBColor(RandUtil.nextFloat(), 1.0f, 1.0f), Color.getHSBColor(this.hue, 1.0f, 1.0f)));
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(1.0f, 1.0f));
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 3.0f), 0.0f));
                build.setAcceleration(new Vec3d(0.0, -0.1, 0.0));
                double radius = 8.0f * RandUtil.nextFloat();
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double x = radius * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = radius * (double)MathHelper.func_76126_a((float)((float)theta));
                build.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(3.0, 20.0), z));
                build.setMotion(new Vec3d(x / 6.0, 0.0, z / 6.0));
            });
        }));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)RandUtil.nextInt(1, 5), (int)0, (i, build) -> {
            this.hue = this.hue >= 1.0f ? 0.0f : (float)((double)this.hue + 0.1);
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.0f), 0.0f));
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.getHSBColor(RandUtil.nextFloat(), 1.0f, 1.0f), Color.getHSBColor(this.hue, 1.0f, 1.0f)));
        });
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)5, (int)0, (i, build) -> {
            this.hue = this.hue >= 1.0f ? 0.0f : (float)((double)this.hue + 0.1);
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 0.5f), 0.0f));
            build.setLifetime(RandUtil.nextInt(40, 80));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.getHSBColor(RandUtil.nextFloat(), 1.0f, 1.0f), Color.getHSBColor(this.hue, 1.0f, 1.0f)));
            build.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0)), new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0)), new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0))));
        });
    }

    @Override
    public void hitEntity(@NotNull World world, @NotNull IGrenadeEntity grenade, @NotNull Entity entity, float intensity) {
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)ModPotions.DISCO, 200));
        }
    }

    @Override
    public float range(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return 16.0f;
    }
}

