/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.api.IGrenadeEntity;
import com.teamwizardry.shotgunsandglitter.api.LingerObject;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.CommonEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.potions.ModPotions;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class GrenadeEffectBlizzard
implements GrenadeEffect {
    @Override
    public String getID() {
        return "blizzard";
    }

    @Override
    public float range(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return 30.0f;
    }

    @Override
    public float damage(@NotNull World world, @NotNull IGrenadeEntity grenade, float intensity) {
        return intensity * 2.0f;
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        if (!world.field_72995_K) {
            CommonEventHandler.lingerObjects.add(new LingerObject(world, grenade.getPositionAsVector(), 10, lingerObject -> {
                for (int i = 0; i < 3; ++i) {
                    EntityFallingBlock droppingBlock = new EntityFallingBlock(lingerObject.world, lingerObject.pos.field_72450_a, lingerObject.pos.field_72448_b, lingerObject.pos.field_72449_c, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(RandUtil.nextInt(1, 6))));
                    droppingBlock.field_145812_b = 1;
                    droppingBlock.field_70159_w = RandUtil.nextDouble(-1.0, 1.0);
                    droppingBlock.field_70181_x = RandUtil.nextDouble(0.3, 1.0);
                    droppingBlock.field_70179_y = RandUtil.nextDouble(-1.0, 1.0);
                    droppingBlock.field_70133_I = true;
                    lingerObject.world.func_72838_d((Entity)droppingBlock);
                }
            }));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)1, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), 0.0f));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
            build.setDeceleration(new Vec3d(0.9, 0.9, 0.9));
            double radius = RandUtil.nextDouble(0.1, 0.3);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        ClientEventHandler.lingerObjects.add(new LingerObject(world, grenade.getPositionAsVector(), 20, lingerObject -> {
            if (lingerObject.world.func_82737_E() % 4L == 0L) {
                lingerObject.world.func_184134_a(lingerObject.pos.field_72450_a, lingerObject.pos.field_72448_b, lingerObject.pos.field_72449_c, (SoundEvent)ModSounds.COLD_WIND, SoundCategory.PLAYERS, 2.0f, 1.0f, false);
            }
            ParticleBuilder glitter = new ParticleBuilder(10);
            glitter.setRender(ClientEventHandler.SPARKLE);
            glitter.setCollision(true);
            glitter.setCanBounce(true);
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)10, (int)0, (i, build) -> {
                build.setLifetime(RandUtil.nextInt(50, 100));
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 4.0f), 0.0f));
                build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.1), 0.0));
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
                build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.01, -0.05), 0.0));
                double radius = RandUtil.nextDouble(1.0, 4.0);
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = radius * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                build.setMotion(new Vec3d(x, RandUtil.nextDouble(0.0, radius), z));
            });
        }));
    }

    @Override
    public void hitEntity(@NotNull World world, @NotNull IGrenadeEntity grenade, @NotNull Entity entity, float intensity) {
        GrenadeEffect.super.hitEntity(world, grenade, entity, intensity);
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)ModPotions.FROST, (int)(300.0f * intensity), (int)(3.0f * intensity)));
        }
    }
}

