/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.potions.ModPotions;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectTranq
implements BulletEffect {
    @Override
    public String getID() {
        return "tranq";
    }

    @Override
    public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        hitEntity.func_70097_a(DamageSource.func_76356_a((Entity)bullet.getAsEntity(), (Entity)hitEntity), 0.0f);
        if (hitEntity instanceof EntityLivingBase && !world.field_72995_K) {
            ((EntityLivingBase)hitEntity).func_70690_d(new PotionEffect((Potion)ModPotions.TRANQUILIZER, (int)(120.0f * bullet.getBulletType().damage)));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.disableMotionCalculation();
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)100, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(20, 40));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.GREEN, Color.CYAN));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 0.8f), 0.0f));
            build.setDeceleration(new Vec3d(0.7, 0.7, 0.7));
            double radius = 2.0f * RandUtil.nextFloat();
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double x = radius * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = radius * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-2.0, 2.0), z));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.disableMotionCalculation();
        glitter.disableRandom();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)1, (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(0.5f, 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.GREEN, Color.CYAN));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.BULLET_FLYBY;
    }

    @Override
    @Nullable
    public SoundEvent getFireSound() {
        return ModSounds.BULLET_FLYBY;
    }

    @Override
    public float getVolume() {
        return RandUtil.nextFloat(10.0f, 10.5f);
    }
}

