/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectTainted
implements BulletEffect {
    @Override
    public String getID() {
        return "tainted";
    }

    @Override
    public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        BulletEffect.super.onCollideEntity(world, bullet, hitEntity);
        if (hitEntity instanceof EntityLivingBase && !world.field_72995_K) {
            ((EntityLivingBase)hitEntity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, bullet.getBulletType().ordinal()));
        }
        return true;
    }

    @Override
    public boolean onCollideBlock(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull BlockPos pos, @NotNull IBlockState state) {
        if (!world.field_72995_K) {
            EntityAreaEffectCloud aEC = new EntityAreaEffectCloud(world, bullet.posX(), bullet.posY(), bullet.posZ());
            aEC.func_184481_a(bullet.getEntityThrower());
            aEC.func_184483_a(3.0f);
            aEC.func_184495_b(-0.25f);
            aEC.func_184485_d(10);
            aEC.func_184487_c(-aEC.func_184490_j() / (float)aEC.func_184489_o());
            aEC.func_184484_a(PotionTypes.field_185218_A);
            world.func_72838_d((Entity)aEC);
        }
        return true;
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)30, (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(0.5f, 1.0f));
            build.setLifetime(RandUtil.nextInt(20, 40));
            build.setColor(RandUtil.nextBoolean() ? Color.GREEN : new Color(11730688));
            build.setMotion(new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.3, 0.3), RandUtil.nextDouble(-0.1, 0.1)));
        });
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)100, (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(0.5f, 1.0f));
            build.setLifetime(RandUtil.nextInt(20, 40));
            build.setColor(RandUtil.nextBoolean() ? Color.GREEN : new Color(11730688));
            build.setDeceleration(new Vec3d(0.95, 0.95, 0.95));
            double radius = 0.5 * (double)RandUtil.nextFloat();
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double x = radius * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = radius * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(0.05, 0.15), z));
        });
    }

    @Override
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)1, (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(0.5f, 1.0f));
            build.setLifetime(RandUtil.nextInt(20, 40));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.01, -0.05), 0.0));
            build.setColor(RandUtil.nextBoolean() ? Color.GREEN : new Color(11730688));
        });
        if (RandUtil.nextInt(5) == 0) {
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)10, (int)0, (i, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(0.5f, 1.0f));
                build.setLifetime(RandUtil.nextInt(20, 40));
                build.setColor(RandUtil.nextBoolean() ? Color.GREEN : new Color(11730688));
                build.setDeceleration(new Vec3d(0.9, 0.9, 0.9));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)));
            });
        }
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.ETHEREAL;
    }
}

