/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectPsychic
implements BulletEffect {
    @Override
    public String getID() {
        return "psychic";
    }

    @Override
    public void onUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        List targets = world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(bullet.posX() - 10.0, bullet.posY() - 10.0, bullet.posZ() - 10.0, bullet.posX() + 10.0, bullet.posY() + 10.0, bullet.posZ() + 10.0), entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            Vec3d motionVec = new Vec3d(bullet.motionX(), bullet.motionY(), bullet.motionZ());
            Vec3d differenceVec = entity.func_174791_d().func_178788_d(bullet.getPositionAsVector());
            double dot = motionVec.func_72432_b().func_72430_b(differenceVec.func_72432_b());
            return differenceVec.func_189985_c() < 56.25 && dot >= 0.75;
        });
        Vec3d acceleration = Vec3d.field_186680_a;
        for (EntityLivingBase target : targets) {
            Vec3d differenceVec = target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O, 0.0).func_178788_d(bullet.getPositionAsVector());
            acceleration = acceleration.func_178787_e(differenceVec.func_186678_a(Math.pow(differenceVec.func_72433_c(), -3.0)));
        }
        acceleration = acceleration.func_72432_b().func_186678_a((double)this.getVelocity(world, bullet.getBulletType()) * 0.75);
        bullet.getAsEntity().field_70159_w += acceleration.field_72450_a;
        bullet.getAsEntity().field_70181_x += acceleration.field_72448_b;
        bullet.getAsEntity().field_70179_y += acceleration.field_72449_c;
        if (RandUtil.nextInt(20) == 0) {
            world.func_184134_a(bullet.posX(), bullet.posY(), bullet.posZ(), (SoundEvent)ModSounds.BULLET_FLYBY, SoundCategory.PLAYERS, RandUtil.nextFloat(0.8f, 1.0f), RandUtil.nextFloat(0.8f, 1.2f), false);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        Vec3d position = bullet.getPositionAsVector();
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.setColor(new Color(13179391));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)100, (int)0, (i, build) -> {
            double radius = RandUtil.nextDouble(0.1, 1.0);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 1.0f), 0.0f));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-1.0, 1.0), z));
            build.setTick(particle -> {
                if (particle.getAge() >= particle.getLifetime() / 30) {
                    particle.setVelocity(particle.getVelocity().func_178787_e(bullet.getPositionAsVector().func_178788_d(particle.getPos()).func_72432_b().func_186678_a(0.06666666666666667)));
                    particle.setAcceleration(Vec3d.field_186680_a);
                } else {
                    particle.setAcceleration(new Vec3d(0.0, -0.05, 0.0));
                }
            });
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder builder = new ParticleBuilder(50);
        builder.setRender(ClientEventHandler.SPARKLE);
        builder.disableRandom();
        builder.setColor(new Color(13179391));
        float size = 0.5f;
        ParticleSpawner.spawn((ParticleBuilder)builder, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)2, (int)0, (i, particleBuilder) -> {
            particleBuilder.setAlphaFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            particleBuilder.setScaleFunction((InterpFunction)new InterpScale(size, 0.3f));
        });
        double scatter = 0.1f;
        ParticleSpawner.spawn((ParticleBuilder)builder, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)2, (int)0, (i, particleBuilder) -> {
            particleBuilder.setAlphaFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            particleBuilder.setScaleFunction((InterpFunction)new InterpScale(size, 0.3f));
            Vec3d offset = new Vec3d(RandUtil.nextDouble(-scatter, scatter), RandUtil.nextDouble(-scatter, scatter), RandUtil.nextDouble(-scatter, scatter));
            particleBuilder.setPositionOffset(offset);
        });
        ParticleSpawner.spawn((ParticleBuilder)builder, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)2, (int)0, (i, particleBuilder) -> {
            particleBuilder.setAlphaFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            particleBuilder.setScaleFunction((InterpFunction)new InterpScale(size, 0.3f));
            Vec3d offset = new Vec3d(RandUtil.nextDouble(-scatter, scatter), RandUtil.nextDouble(-scatter, scatter), RandUtil.nextDouble(-scatter, scatter));
            particleBuilder.setPositionOffset(offset);
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.SMOKE_BLAST;
    }

    @Override
    public float getVelocity(@NotNull World world, @NotNull BulletType bulletType) {
        return 1.0f;
    }
}

