/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectPiercing
implements BulletEffect {
    @Override
    public String getID() {
        return "piercing";
    }

    @Override
    public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        BulletEffect.super.onCollideEntity(world, bullet, hitEntity);
        return false;
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.disableMotionCalculation();
        glitter.setColor(Color.YELLOW);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)30, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(10, 30));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.8f, 1.4f), 0.0f));
            build.setMotion(new Vec3d(RandUtil.nextDouble(-0.3, 0.3), RandUtil.nextDouble(-0.3, 0.6), RandUtil.nextDouble(-0.3, 0.3)));
        });
    }

    @Override
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.disableMotionCalculation();
        glitter.setColor(Color.YELLOW);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)5, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(10, 30));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.1f, 0.5f), 0.0f));
            Vec3d position = new InterpCircle(Vec3d.field_186680_a, new Vec3d(bullet.motionX(), bullet.motionY(), bullet.motionZ()).func_72432_b(), 1.0f, 50.0f, 0.0f).get(RandUtil.nextFloat());
            build.setMotion(position.func_186678_a(0.1));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.POP;
    }
}

