/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityDroppingBlock;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectImpact
implements BulletEffect {
    @Override
    public String getID() {
        return "impact";
    }

    @Override
    public float knockbackStrength(@NotNull World world, @NotNull IBulletEntity bullet) {
        return bullet.getBulletType().knockbackStrength * 2.0f;
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        if (!world.field_72995_K) {
            BulletType type = bullet.getBulletType();
            float range = type.damage * 0.75f;
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)bullet.getPositionAsBlockPos().func_177963_a((double)(-range), (double)(-range), (double)(-range)), (BlockPos)bullet.getPositionAsBlockPos().func_177963_a((double)range, (double)(range / 2.0f), (double)range))) {
                Entity block;
                if (!(pos.func_177951_i((Vec3i)bullet.getPositionAsBlockPos()) <= (double)(range * range)) || (block = EntityDroppingBlock.dropBlock((Entity)bullet.getEntityThrower(), world, pos, null, false, true, true)) == null) continue;
                block.field_70159_w = RandUtil.nextDouble(-0.5, 0.5);
                block.field_70181_x = 0.625;
                block.field_70179_y = RandUtil.nextDouble(-0.5, 0.5);
                block.field_70133_I = true;
                world.func_72838_d(block);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)100, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(20, 50));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 2.0f), 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(new Color(11748084), new Color(0x700000)));
            build.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0)), new Vec3d(RandUtil.nextDouble(-3.0, 3.0), RandUtil.nextDouble(-3.0, 3.0), RandUtil.nextDouble(-3.0, 3.0)), new Vec3d(RandUtil.nextDouble(-3.0, 3.0), RandUtil.nextDouble(-3.0, 3.0), RandUtil.nextDouble(-3.0, 3.0))));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)3, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(5, 20));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 2.0f), 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(new Color(11748084), new Color(0x700000)));
            build.setMotion(new Vec3d(bullet.motionX(), bullet.motionY(), bullet.motionZ()).func_186678_a(0.5));
            build.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)), new Vec3d(RandUtil.nextDouble(-2.0, 2.0), RandUtil.nextDouble(-2.0, 2.0), RandUtil.nextDouble(-2.0, 2.0)), new Vec3d(RandUtil.nextDouble(-2.0, 2.0), RandUtil.nextDouble(-2.0, 2.0), RandUtil.nextDouble(-2.0, 2.0))));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.THUNDERBLAST;
    }
}

