/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpLine;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectHookshot
implements BulletEffect {
    @Override
    public String getID() {
        return "hookshot";
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        EntityLivingBase thrower = bullet.getEntityThrower();
        if (thrower != null) {
            Vec3d differenceVec = bullet.getPositionAsVector().func_178788_d(thrower.func_174791_d()).func_72432_b().func_186678_a(0.5 * (double)bullet.getBulletType().damage);
            thrower.field_70159_w = differenceVec.field_72450_a;
            thrower.field_70181_x = Math.max(differenceVec.field_72448_b, 0.0) + 0.5;
            thrower.field_70179_y = differenceVec.field_72449_c;
            thrower.field_70133_I = true;
        }
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        Vec3d position = bullet.getPositionAsVector();
        int throwerID = bullet.getCasterId();
        if (throwerID == -1) {
            return;
        }
        Entity thrower = world.func_73045_a(throwerID);
        if (thrower == null) {
            return;
        }
        Vec3d throwerPos = thrower.func_174791_d().func_72441_c(0.0, (double)thrower.func_70047_e(), 0.0);
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new InterpLine(throwerPos, position), (int)50, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(30, 50));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), 0.0f));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.005, -0.001), 0.0));
            build.setMotion(new Vec3d(RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0)));
        });
    }

    @Override
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        Vec3d position = bullet.getPositionAsVector();
        ParticleBuilder glitter = new ParticleBuilder(50);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)5, (int)0, (i, build) -> {
            build.setMotion(new Vec3d(bullet.motionX(), bullet.motionY(), bullet.motionZ()).func_186678_a(-0.1));
            build.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
            build.setLifetime(RandUtil.nextInt(30, 60));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.0f), 0.0f));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.005, -0.001), 0.0));
            build.setJitter(4, new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.CHAINY_ZAP;
    }
}

