/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectGraviton
implements BulletEffect {
    private final int direction;
    private final String idSuffix;

    public BulletEffectGraviton(boolean outwards) {
        this.direction = outwards ? -1 : 1;
        this.idSuffix = outwards ? "out" : "in";
    }

    @Override
    public String getID() {
        return "gravity_" + this.idSuffix;
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        double range = 10.0;
        for (EntityLivingBase target : world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(bullet.posX() - range, bullet.posY() - range, bullet.posZ() - range, bullet.posX() + range, bullet.posY() + range, bullet.posZ() + range), entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            Vec3d differenceVec = entity.func_174791_d().func_178788_d(bullet.getPositionAsVector());
            return differenceVec.func_189985_c() < range * range && differenceVec.func_189985_c() != 0.0;
        })) {
            Vec3d differenceVec = bullet.getPositionAsVector().func_178788_d(target.func_174791_d());
            differenceVec = differenceVec.func_186678_a((double)this.direction / differenceVec.func_189985_c());
            target.field_70159_w = differenceVec.field_72450_a * (double)bullet.getBulletType().damage;
            target.field_70181_x = Math.min(Math.max(differenceVec.field_72448_b, 0.0), 2.0) * (double)bullet.getBulletType().damage + 0.25;
            target.field_70179_y = differenceVec.field_72449_c * (double)bullet.getBulletType().damage;
            target.field_70133_I = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        Color color2;
        Color color;
        if (this.direction == 1) {
            color = Color.CYAN;
            color2 = Color.BLUE;
        } else {
            color = Color.RED;
            color2 = Color.ORANGE;
        }
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.03, -0.04), 0.0));
        glitter.setCanBounce(true);
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)((int)(100.0f * bullet.getFalloff())), (int)0, (i, build) -> {
            build.setMotion(Vec3d.field_186680_a);
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScale(RandUtil.nextFloat(0.2f, 1.0f));
            if (this.direction == 1) {
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(RandUtil.nextFloat(0.7f, 1.0f), RandUtil.nextFloat(0.5f, 1.0f)));
                double radius = RandUtil.nextDouble(5.0, 10.0);
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = radius * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                build.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
                build.addMotion(build.getPositionOffset().func_186678_a(-1.0 / RandUtil.nextDouble(10.0, 30.0)));
            } else {
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, RandUtil.nextFloat(0.5f, 1.0f)));
                double radius = RandUtil.nextDouble(0.2, 1.0);
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = radius * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                build.addMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
            }
            if (RandUtil.nextBoolean()) {
                build.setColor(color);
            } else {
                build.setColor(color2);
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        Color color2;
        Color color;
        if (this.direction == 1) {
            color = Color.CYAN;
            color2 = Color.BLUE;
        } else {
            color = Color.RED;
            color2 = Color.ORANGE;
        }
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.disableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)10, (int)0, (i, build) -> {
            build.setMotion(Vec3d.field_186680_a);
            build.setLifetime(RandUtil.nextInt(10, 20));
            build.setScale(RandUtil.nextFloat(0.2f, 1.0f));
            if (this.direction == 1) {
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(RandUtil.nextFloat(0.7f, 1.0f), RandUtil.nextFloat(0.5f, 1.0f)));
                double radius = RandUtil.nextDouble(0.3, 1.0);
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = radius * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                build.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
                build.addMotion(build.getPositionOffset().func_186678_a(-1.0 / RandUtil.nextDouble(5.0, 10.0)));
            } else {
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, RandUtil.nextFloat(0.5f, 1.0f)));
                double radius = RandUtil.nextDouble(0.1, 0.2);
                double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                double r = radius * (double)RandUtil.nextFloat();
                double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                build.addMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
            }
            if (RandUtil.nextBoolean()) {
                build.setColor(color);
            } else {
                build.setColor(color2);
            }
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.ELECTRIC_BLAST;
    }
}

