/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.potions.ModPotions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectFrost
implements BulletEffect {
    @Override
    public String getID() {
        return "frost";
    }

    @Override
    public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        BulletEffect.super.onCollideEntity(world, bullet, hitEntity);
        if (hitEntity instanceof EntityLivingBase && !world.field_72995_K) {
            ((EntityLivingBase)hitEntity).func_70690_d(new PotionEffect((Potion)ModPotions.FROST, 300, bullet.getBulletType().ordinal() + 1));
        }
        return true;
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        if (!world.field_72995_K) {
            for (EntityLivingBase target : world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(bullet.posX() - 10.0, bullet.posY() - 10.0, bullet.posZ() - 10.0, bullet.posX() + 10.0, bullet.posY() + 10.0, bullet.posZ() + 10.0), entity -> {
                if (entity == null || !entity.func_70089_S()) {
                    return false;
                }
                Vec3d differenceVec = entity.func_174791_d().func_178788_d(bullet.getPositionAsVector());
                return differenceVec.func_189985_c() < 56.25 && differenceVec.func_189985_c() != 0.0;
            })) {
                Vec3d difference = target.func_174791_d().func_178788_d(bullet.getPositionAsVector());
                double struckStrength = Math.min(1.0 / difference.func_72433_c(), 0.3333333333333333);
                int duration = (int)(1400.0 - struckStrength * 1000.0 / 6.0);
                target.func_70690_d(new PotionEffect((Potion)ModPotions.FROST, duration, bullet.getBulletType().ordinal()));
            }
        }
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)50, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 4.0f), 0.0f));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.1), 0.0));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.01, -0.05), 0.0));
            double radius = RandUtil.nextDouble(0.5, 2.0);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
        });
    }

    @Override
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)1, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), 0.0f));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
            build.setDeceleration(new Vec3d(0.9, 0.9, 0.9));
            double radius = RandUtil.nextDouble(0.1, 0.3);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.COLD_WIND;
    }
}

