/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.potions.ModPotions;
import java.awt.Color;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectFlash
implements BulletEffect {
    @Override
    public String getID() {
        return "flash";
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        if (!world.field_72995_K) {
            int radius = (int)bullet.getBulletType().damage * 50;
            for (EntityLivingBase target : world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(bullet.posX() - (double)radius, bullet.posY() - (double)radius, bullet.posZ() - (double)radius, bullet.posX() + (double)radius, bullet.posY() + (double)radius, bullet.posZ() + (double)radius), entity -> {
                if (entity == null || !entity.func_70089_S()) {
                    return false;
                }
                Vec3d look = entity.func_70676_i(0.0f);
                Vec3d differenceVec = bullet.getPositionAsVector().func_178788_d(entity.func_174791_d());
                double dot = look.func_72430_b(differenceVec.func_72432_b());
                return differenceVec.func_189985_c() <= (double)(radius * radius) && dot >= 0.0;
            })) {
                Vec3d look = target.func_70676_i(0.0f);
                Vec3d differenceVec = bullet.getPositionAsVector().func_178788_d(target.func_174791_d());
                double dot = look.func_72430_b(differenceVec.func_72432_b());
                double lengthIntensity = Math.min(1.0 / differenceVec.func_72433_c(), 0.1) * dot;
                int amp = (int)(100.0 * lengthIntensity / 3.0 + 0.16666666666666666);
                int duration = (int)(44.44444444444444 + lengthIntensity * 50000.0 / 9.0);
                target.func_70690_d(new PotionEffect((Potion)ModPotions.FLASH, duration, amp));
            }
        }
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)((int)(50.0f * bullet.getFalloff())), (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 3.0f), 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(new Color(12713964), new Color(16775873)));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.1), 0.0));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
            build.setDeceleration(new Vec3d(0.9, 0.9, 0.9));
            double radius = RandUtil.nextDouble(3.0, 5.0);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
        });
    }

    @Override
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)1, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(5, 20));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 3.0f), 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(new Color(12713964), new Color(16775873)));
            build.setMotion(new Vec3d(bullet.motionX(), bullet.motionY(), bullet.motionZ()));
            build.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)), new Vec3d(RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0)), new Vec3d(RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0))));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.SMOKE_BLAST;
    }
}

