/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtilSeed;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectFirework
implements BulletEffect {
    @Override
    public String getID() {
        return "firework";
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        Vec3d position = bullet.getPositionAsVector();
        ParticleBuilder glitter = new ParticleBuilder(50);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        RandUtilSeed seed = new RandUtilSeed(glitter.hashCode());
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)50, (int)0, (i, build) -> {
            build.setDeceleration(new Vec3d(RandUtil.nextDouble(0.8, 1.0), RandUtil.nextDouble(0.8, 1.0), RandUtil.nextDouble(0.8, 1.0)));
            build.setLifetime(RandUtil.nextInt(30, 70));
            build.setColor(Color.getHSBColor(seed.nextFloat(), 1.0f, 1.0f));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.0f), RandUtil.nextFloat(0.0f, 0.2f)));
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-1.0, 1.0), z));
            build.setJitter(10, new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
        });
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)100, (int)0, (i, build) -> {
            build.setDeceleration(new Vec3d(RandUtil.nextDouble(0.8, 1.0), RandUtil.nextDouble(0.8, 1.0), RandUtil.nextDouble(0.8, 1.0)));
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setColor(Color.getHSBColor(seed.nextFloat(), 1.0f, 1.0f));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), 0.0f));
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-2.0, 2.0), z));
            build.setJitter(10, new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        Vec3d position = bullet.getPositionAsVector();
        ParticleBuilder glitter = new ParticleBuilder(50);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 0.3f));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        RandUtilSeed seed = new RandUtilSeed(glitter.hashCode());
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)5, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(5, 10));
            build.setColor(Color.getHSBColor(seed.nextFloat(), 1.0f, 1.0f));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 0.5f), 0.0f));
            Vec3d motion = new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(-0.05, 0.05));
            build.addMotion(motion);
            build.setJitter(3, new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(-0.05, 0.05)));
        });
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)5, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(5, 20));
            build.setColor(Color.getHSBColor(seed.nextFloat(), 1.0f, 1.0f));
            build.setScale(RandUtil.nextFloat(0.5f, 1.0f));
            Vec3d motion = new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1));
            build.addMotion(motion);
            build.addAcceleration(new Vec3d(motion.field_72450_a * -0.01, 0.0, motion.field_72449_c * -0.01));
            build.setJitter(10, new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
        });
        if (RandUtil.nextInt(4) == 0) {
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)5, (int)0, (i, build) -> {
                build.setLifetime(RandUtil.nextInt(50, 80));
                build.setColor(Color.getHSBColor(seed.nextFloat(), 1.0f, 1.0f));
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 2.0f), 0.0f));
                Vec3d motion = new Vec3d(RandUtil.nextDouble(-0.4, 0.4), RandUtil.nextDouble(-0.4, 0.4), RandUtil.nextDouble(-0.4, 0.4));
                build.addMotion(motion);
                build.addAcceleration(new Vec3d(motion.field_72450_a * -0.01, RandUtil.nextDouble(-0.005, -0.01), motion.field_72449_c * -0.01));
                build.setJitter(5, new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)));
            });
        }
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.POP;
    }

    @Override
    public float getVolume() {
        return RandUtil.nextFloat(4.0f, 4.5f);
    }
}

