/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectDraconic
implements BulletEffect {
    @Override
    public String getID() {
        return "draconic";
    }

    @Override
    public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        if (!world.field_72995_K) {
            world.func_72885_a(bullet.getAsEntity(), bullet.posX(), bullet.posY(), bullet.posZ(), bullet.getBulletType().damage, true, !world.func_82736_K().func_82766_b("mobGriefing"));
        }
    }

    @Override
    public void onUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        if (!world.field_72995_K) {
            for (EntityLivingBase target : world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(bullet.posX() - 4.0, bullet.posY() - 4.0, bullet.posZ() - 4.0, bullet.posX() + 4.0, bullet.posY() + 4.0, bullet.posZ() + 4.0), entity -> {
                if (entity == null || !entity.func_70089_S() || entity == bullet.getEntityThrower()) {
                    return false;
                }
                Vec3d differenceVec = entity.func_174791_d().func_178788_d(bullet.getPositionAsVector());
                return differenceVec.func_189985_c() < 16.0;
            })) {
                target.func_70015_d(10);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)50, (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), 0.0f));
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setColorFunction((InterpFunction)new InterpColorHSV(RandUtil.nextBoolean() ? Color.RED : Color.ORANGE, RandUtil.nextBoolean() ? Color.RED : Color.WHITE));
            build.setDeceleration(new Vec3d(0.6, 0.6, 0.6));
            double radius = 3.0f * RandUtil.nextFloat();
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double x = radius * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = radius * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(0.1, 3.0), z));
            build.setJitter(3, new Vec3d(RandUtil.nextDouble(-0.4, 0.4), RandUtil.nextDouble(-0.4, 0.4), RandUtil.nextDouble(-0.4, 0.4)));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)RandUtil.nextInt(1, 5), (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.0f), 0.0f));
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.WHITE, Color.RED));
        });
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)5, (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 0.5f), 0.0f));
            build.setLifetime(RandUtil.nextInt(40, 80));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.RED, Color.WHITE));
            build.setPositionFunction((InterpFunction)new InterpBezier3D(Vec3d.field_186680_a, new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0)), new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0)), new Vec3d(RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0), RandUtil.nextDouble(-5.0, 5.0))));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.FIREBALL;
    }

    @Override
    public float getVolume() {
        return RandUtil.nextFloat(3.0f, 3.5f);
    }
}

