/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectBiotic
implements BulletEffect {
    @Override
    public String getID() {
        return "biotic";
    }

    @Override
    public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        hitEntity.func_70097_a(DamageSource.field_76377_j, 1.0E-6f);
        if (hitEntity instanceof EntityLivingBase && !world.field_72995_K) {
            ((EntityLivingBase)hitEntity).func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, bullet.getBulletType().ordinal()));
        }
        return true;
    }

    @Override
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCanBounce(true);
        glitter.disableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)((int)(50.0f * bullet.getFalloff())), (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(20, 40));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.4f, 1.0f), 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.RED, Color.YELLOW));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(1.0f, 1.0f));
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            Vec3d offset = new Vec3d(x, RandUtil.nextDouble(-1.0, 1.0), z);
            build.setPositionOffset(offset);
            build.setMotion(offset.func_186678_a(-0.1));
        });
    }

    @Override
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.disableMotionCalculation();
        glitter.setColor(Color.RED);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)15, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(10, 30));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 0.5f), 0.0f));
            build.setColorFunction((InterpFunction)new InterpColorHSV(Color.RED, Color.YELLOW));
        });
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.HEAL;
    }
}

