/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.InterpScale;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityDroppingBlock;
import java.awt.Color;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEffectBalefire
implements BulletEffect {
    @Override
    public String getID() {
        return "balefire";
    }

    @Override
    public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        BulletEffect.super.onCollideEntity(world, bullet, hitEntity);
        hitEntity.func_70015_d(20 + 20 * bullet.getBulletType().ordinal());
        if (hitEntity instanceof EntityLiving && (double)RandUtil.nextDouble() < 0.25) {
            hitEntity.func_174812_G();
        }
        return (double)RandUtil.nextDouble() < 0.8;
    }

    @Override
    public boolean onCollideBlock(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull BlockPos pos, @NotNull IBlockState state) {
        EntityDroppingBlock.dropBlock((Entity)bullet.getEntityThrower(), world, pos, false, true, true, true);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            EntityDroppingBlock.dropBlock((Entity)bullet.getEntityThrower(), world, pos.func_177972_a(facing), false, true, true, true);
        }
        return (double)RandUtil.nextDouble() < 0.8;
    }

    @Override
    public void onUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        if (!world.field_72995_K) {
            int expansion = bullet.getBulletType().ordinal();
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)bullet.getPositionAsBlockPos().func_177982_a(-expansion, 0, -expansion), (BlockPos)bullet.getPositionAsBlockPos().func_177982_a(expansion, -1, expansion))) {
                if (!world.func_175623_d(pos) || world.func_175623_d(pos.func_177977_b())) continue;
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)((int)(50.0f * bullet.getFalloff())), (int)0, (i, build) -> {
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), RandUtil.nextFloat(0.0f, 0.5f)));
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setColorFunction((InterpFunction)new InterpColorHSV(new Color(8990720), Color.YELLOW));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.04, -0.07), 0.0));
            build.setDeceleration(new Vec3d(0.6, 1.0, 0.6));
            double radius = 3.0f * RandUtil.nextFloat();
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double x = radius * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = radius * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(0.1, 1.0), z));
            build.setJitter(3, new Vec3d(RandUtil.nextDouble(-0.4, 0.4), RandUtil.nextDouble(-0.4, 0.4), RandUtil.nextDouble(-0.4, 0.4)));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        for (int j = 0; j < 5; ++j) {
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)bullet.getPositionAsVector()), (int)5, (int)1, (i, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 1.0f), 0.0f));
                build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.1f, 1.0f));
                build.setLifetime(RandUtil.nextInt(40, 80));
                build.setColorFunction((InterpFunction)new InterpColorHSV(new Color(16761600), Color.YELLOW));
                Vec3d bulletMotion = new Vec3d(bullet.getAsEntity().field_70159_w, bullet.getAsEntity().field_70181_x, bullet.getAsEntity().field_70179_y);
                Vec3d norm = bulletMotion.func_72432_b();
                build.setMotion(norm.func_186678_a(0.1).func_72441_c(norm.field_72450_a * RandUtil.nextDouble(0.0, 0.3), norm.field_72448_b * RandUtil.nextDouble(0.0, 0.3), norm.field_72449_c * RandUtil.nextDouble(0.0, 0.3)));
            });
        }
    }

    @Override
    @Nullable
    public SoundEvent getImpactSound() {
        return ModSounds.FIRE;
    }

    @Override
    public float getVolume() {
        return RandUtil.nextFloat(4.0f, 4.5f);
    }
}

