/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.common.core;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.common.blocks.ModBlocks;
import com.teamwizardry.shotgunsandglitter.common.core.CommonEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.MessageBulletImpactBlock;
import com.teamwizardry.shotgunsandglitter.common.core.MessageBulletImpactEntity;
import com.teamwizardry.shotgunsandglitter.common.core.MessageGrenadeExplode;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import com.teamwizardry.shotgunsandglitter.common.core.ModTab;
import com.teamwizardry.shotgunsandglitter.common.effects.ModEffects;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityBullet;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityGrenade;
import com.teamwizardry.shotgunsandglitter.common.entity.ModEntities;
import com.teamwizardry.shotgunsandglitter.common.items.ModItems;
import com.teamwizardry.shotgunsandglitter.common.potions.ModPotions;
import com.teamwizardry.shotgunsandglitter.common.recipes.ModRecipes;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        ModEffects.init();
        ModItems.init();
        ModBlocks.init();
        ModEntities.init();
        new ModTab();
        new ModPotions();
        ModSounds.init();
        ModRecipes.init();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void updateBulletEntity(World world, EntityBullet bullet, BulletEffect bulletEffect) {
        bulletEffect.onUpdate(world, bullet);
    }

    public boolean collideBulletWithBlock(World world, EntityBullet bullet, BlockPos hit, IBlockState state, BulletEffect bulletEffect, Vec3d position) {
        bulletEffect.onImpact(world, bullet);
        if (!world.field_72995_K) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new MessageBulletImpactBlock(hit, bullet.func_145782_y(), position), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), position.field_72450_a, position.field_72448_b, position.field_72449_c, 64.0));
        }
        return bulletEffect.onCollideBlock(world, bullet, hit, state);
    }

    public boolean collideBulletWithEntity(World world, EntityBullet bullet, Entity entity, BulletEffect bulletEffect, Vec3d position) {
        bulletEffect.onImpact(world, bullet);
        if (!world.field_72995_K) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new MessageBulletImpactEntity(entity.func_145782_y(), bullet.func_145782_y(), position), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), position.field_72450_a, position.field_72448_b, position.field_72449_c, 64.0));
        }
        return bulletEffect.onCollideEntity(world, bullet, entity);
    }

    public void grenadeUpdate(World world, EntityGrenade grenade, GrenadeEffect grenadeEffect) {
        grenadeEffect.onUpdate(world, grenade);
    }

    public void grenadeImpact(World world, EntityGrenade grenade, GrenadeEffect grenadeEffect, Vec3d position) {
        grenadeEffect.onImpact(world, grenade);
        if (!world.field_72995_K) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new MessageGrenadeExplode(grenade.func_145782_y(), position), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), position.field_72450_a, position.field_72448_b, position.field_72449_c, 64.0));
        }
    }
}

