/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.client.render;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.base.block.tile.TileMod;
import com.teamwizardry.librarianlib.features.tesr.TileRenderHandler;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.shotgunsandglitter.common.tile.TileMiniTurret;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="shotgunsandglitter")
public class TESRMiniTurret
extends TileRenderHandler<TileMiniTurret> {
    private static Animator ANIMATOR = new Animator();
    public double rotationPitch = 0.0;
    public double rotationYaw = 0.0;
    public double currentTarget = -1.0;
    public boolean animating = false;
    public boolean firing = false;
    private static IBakedModel mini_turret_head = null;
    private static IBakedModel mini_turret_barrels = null;
    private static IBakedModel mini_turret_barrel_right = null;
    private static IBakedModel mini_turret_barrel_left = null;

    public TESRMiniTurret(@NotNull TileMiniTurret tile) {
        super((TileMod)tile);
    }

    private static boolean getBakedModels() {
        IModel model;
        if (mini_turret_head == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("shotgunsandglitter", "block/mini_turret_head"));
                mini_turret_head = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mini_turret_barrels == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("shotgunsandglitter", "block/mini_turret_barrels"));
                mini_turret_barrels = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mini_turret_barrel_right == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("shotgunsandglitter", "block/mini_turret_barrel_right"));
                mini_turret_barrel_right = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mini_turret_barrel_left == null) {
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("shotgunsandglitter", "block/mini_turret_barrel_left"));
                mini_turret_barrel_left = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mini_turret_barrels != null && mini_turret_head != null && mini_turret_barrel_left != null && mini_turret_barrel_right != null;
    }

    public void render(float partialTicks, int destroyStage, float alpha) {
        Entity entity;
        super.render(partialTicks, destroyStage, alpha);
        if (!TESRMiniTurret.getBakedModels()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        TextureManager texturemanager = Minecraft.func_71410_x().field_71446_o;
        if (texturemanager != null) {
            texturemanager.func_110577_a(TextureMap.field_110575_b);
        }
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        if (!((TileMiniTurret)this.tile).firing && (this.firing || this.rotationYaw != 0.0 || this.rotationPitch != 45.0)) {
            this.firing = false;
            this.animating = true;
            BasicAnimation animPitch = new BasicAnimation((Object)this, "rotationPitch");
            animPitch.setDuration(10.0f);
            animPitch.setTo((Object)45);
            animPitch.setEasing((Easing)Easing.easeOutCubic);
            animPitch.setCompletion(() -> {
                this.animating = false;
            });
            ANIMATOR.add(new Animation[]{animPitch});
            BasicAnimation animYaw = new BasicAnimation((Object)this, "rotationYaw");
            animYaw.setDuration(0.0f);
            animYaw.setTo((Object)this.rotationYaw);
            animYaw.setEasing((Easing)Easing.easeOutCubic);
            ANIMATOR.add(new Animation[]{animYaw});
        } else if (((TileMiniTurret)this.tile).firing && !this.firing || ((TileMiniTurret)this.tile).firing && (double)((TileMiniTurret)this.tile).getTargetID() != this.currentTarget) {
            this.animating = true;
            this.firing = true;
            this.currentTarget = ((TileMiniTurret)this.tile).getTargetID();
            Entity entity2 = ((TileMiniTurret)this.tile).func_145831_w().func_73045_a(((TileMiniTurret)this.tile).getTargetID());
            if (entity2 != null) {
                double ix = (double)((TileMiniTurret)this.tile).func_174877_v().func_177958_n() + 0.5;
                double iy = (double)((TileMiniTurret)this.tile).func_174877_v().func_177956_o() + 0.5;
                double iz = (double)((TileMiniTurret)this.tile).func_174877_v().func_177952_p() + 0.5;
                double fx = entity2.field_70165_t;
                double fy = entity2.field_70163_u + (double)entity2.field_70131_O / 2.0;
                double fz = entity2.field_70161_v;
                double subX = ix - fx;
                double subY = iy - fy;
                double subZ = iz - fz;
                double lengthSq = Math.sqrt(subZ * subZ + subX * subX);
                double rotYaw = 180.0 - Math.toDegrees(MathHelper.func_181159_b((double)subZ, (double)subX)) + 90.0;
                double rotPitch = 180.0 - Math.toDegrees(Math.atan2(lengthSq, subY) + Math.PI) + 90.0;
                BasicAnimation animPitch = new BasicAnimation((Object)this, "rotationPitch");
                animPitch.setDuration(10.0f);
                animPitch.setTo((Object)rotPitch);
                animPitch.setEasing((Easing)Easing.easeOutCubic);
                animPitch.setCompletion(() -> {
                    this.animating = false;
                });
                ANIMATOR.add(new Animation[]{animPitch});
                BasicAnimation animYaw = new BasicAnimation((Object)this, "rotationYaw");
                animYaw.setDuration(10.0f);
                animYaw.setTo((Object)rotYaw);
                animYaw.setEasing((Easing)Easing.easeOutCubic);
                animYaw.setCompletion(() -> {
                    this.animating = false;
                });
                ANIMATOR.add(new Animation[]{animYaw});
            }
        } else if (((TileMiniTurret)this.tile).firing && this.firing && !this.animating && (entity = ((TileMiniTurret)this.tile).func_145831_w().func_73045_a(((TileMiniTurret)this.tile).getTargetID())) != null) {
            double ix = (double)((TileMiniTurret)this.tile).func_174877_v().func_177958_n() + 0.5;
            double iy = (double)((TileMiniTurret)this.tile).func_174877_v().func_177956_o() + 0.5;
            double iz = (double)((TileMiniTurret)this.tile).func_174877_v().func_177952_p() + 0.5;
            double fx = entity.field_70165_t;
            double fy = entity.field_70163_u + (double)entity.field_70131_O / 2.0;
            double fz = entity.field_70161_v;
            double subX = ix - fx;
            double subY = iy - fy;
            double subZ = iz - fz;
            double lengthSq = Math.sqrt(subZ * subZ + subX * subX);
            double rotationYaw = 180.0 - Math.toDegrees(MathHelper.func_181159_b((double)subZ, (double)subX)) + 90.0;
            double rotationPitch = 180.0 - Math.toDegrees(Math.atan2(lengthSq, subY) + Math.PI) + 90.0;
            this.rotationYaw = rotationYaw;
            this.rotationPitch = rotationPitch;
        }
        GlStateManager.func_179137_b((double)0.5, (double)0.65, (double)0.5);
        GlStateManager.func_179114_b((float)((float)this.rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(mini_turret_head, 1.0f, 1.0f, 1.0f, 1.0f);
        if (((TileMiniTurret)this.tile).isRightBarrel()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((1.0 - (double)((TileMiniTurret)this.tile).getCooldown() / 40.0) / 5.0 - 0.25));
        }
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(mini_turret_barrel_right, 1.0f, 1.0f, 1.0f, 1.0f);
        if (((TileMiniTurret)this.tile).isRightBarrel()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-((1.0 - (double)((TileMiniTurret)this.tile).getCooldown() / 40.0) / 5.0 - 0.25)));
        }
        if (!((TileMiniTurret)this.tile).isRightBarrel()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((1.0 - (double)((TileMiniTurret)this.tile).getCooldown() / 40.0) / 5.0 - 0.25));
        }
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(mini_turret_barrel_left, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!((TileMiniTurret)this.tile).isRightBarrel()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-((1.0 - (double)((TileMiniTurret)this.tile).getCooldown() / 40.0) / 5.0 - 0.25)));
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    static {
        ClientRunnable.registerReloadHandler(() -> {
            mini_turret_barrels = null;
            mini_turret_head = null;
            mini_turret_barrel_left = null;
            mini_turret_barrel_right = null;
        });
    }
}

