/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.client.core;

import com.teamwizardry.librarianlib.features.utilities.client.CustomBlockMapSprites;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import com.teamwizardry.shotgunsandglitter.common.core.CommonProxy;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityBullet;
import com.teamwizardry.shotgunsandglitter.common.entity.EntityGrenade;
import com.teamwizardry.shotgunsandglitter.common.entity.ModEntities;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ModEntities.initModels();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        CustomBlockMapSprites.INSTANCE.register(new ResourceLocation("shotgunsandglitter", "blocks/mini_turret_head"));
        CustomBlockMapSprites.INSTANCE.register(new ResourceLocation("shotgunsandglitter", "blocks/mini_turret_barrel_left"));
        CustomBlockMapSprites.INSTANCE.register(new ResourceLocation("shotgunsandglitter", "blocks/mini_turret_barrel_right"));
        CustomBlockMapSprites.INSTANCE.register(new ResourceLocation("shotgunsandglitter", "blocks/mini_turret_barrels"));
    }

    @Override
    public void updateBulletEntity(World world, EntityBullet bullet, BulletEffect bulletEffect) {
        super.updateBulletEntity(world, bullet, bulletEffect);
        if (world.field_72995_K) {
            bulletEffect.renderUpdate(world, bullet);
        }
    }

    @Override
    public boolean collideBulletWithBlock(World world, EntityBullet bullet, BlockPos hit, IBlockState state, BulletEffect bulletEffect, Vec3d position) {
        boolean returnValue = super.collideBulletWithBlock(world, bullet, hit, state, bulletEffect, position);
        if (world.field_72995_K) {
            bulletEffect.renderImpact(world, bullet);
            bulletEffect.renderCollideBlock(world, bullet, hit, state);
        }
        return returnValue;
    }

    @Override
    public boolean collideBulletWithEntity(World world, EntityBullet bullet, Entity entity, BulletEffect bulletEffect, Vec3d position) {
        boolean returnValue = super.collideBulletWithEntity(world, bullet, entity, bulletEffect, position);
        if (world.field_72995_K) {
            bulletEffect.renderImpact(world, bullet);
            bulletEffect.renderCollideEntity(world, bullet, entity);
        }
        return returnValue;
    }

    @Override
    public void grenadeImpact(World world, EntityGrenade grenade, GrenadeEffect grenadeEffect, Vec3d position) {
        super.grenadeImpact(world, grenade, grenadeEffect, position);
        if (world.field_72995_K) {
            grenadeEffect.renderImpact(world, grenade);
        }
    }

    @Override
    public void grenadeUpdate(World world, EntityGrenade grenade, GrenadeEffect grenadeEffect) {
        super.grenadeUpdate(world, grenade, grenadeEffect);
        if (world.field_72995_K) {
            grenadeEffect.renderUpdate(world, grenade);
        }
    }
}

