/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.IAmmoItem;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.InternalHandler;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGunItem
extends IAmmoItem {
    public int getReloadCooldownTime(ItemStack var1);

    public int getFireCooldownTime(ItemStack var1);

    public float getInaccuracy(ItemStack var1);

    public int headKnockStrength(ItemStack var1);

    @Nullable
    public SoundEvent[] getFireSoundEvents(ItemStack var1);

    @Nullable
    public SoundEvent getReloadSoundEvent(ItemStack var1);

    @Override
    default public boolean destroyable(@NotNull ItemStack stack) {
        return false;
    }

    default public int getFireCount(ItemStack stack) {
        return 1;
    }

    default public boolean shouldConsumeAmmo(ItemStack stack, int firedPreviouslyThisShot) {
        return firedPreviouslyThisShot == 0;
    }

    default public float getPotency() {
        return 1.0f;
    }

    default public void fireGun(World world, EntityPlayer player, final ItemStack stack, EnumHand hand) {
        List<BulletEffect> ammo = this.getEffectsFromItem(stack);
        if (ammo.isEmpty()) {
            return;
        }
        int consumed = 0;
        BulletEffect bulletEffect = ammo.get(0);
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getFireCount(stack); ++i) {
                if (this.shouldConsumeAmmo(stack, i)) {
                    if (ammo.size() <= consumed) break;
                    bulletEffect = ammo.get(consumed++);
                }
                IBulletEntity bullet = InternalHandler.INTERNAL_HANDLER.newBulletEntity(world, (EntityLivingBase)player, this.getBulletType(stack), bulletEffect, this.getInaccuracy(stack), this.getPotency());
                bullet.getAsEntity().func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v);
                world.func_72838_d(bullet.getAsEntity());
            }
        } else if (bulletEffect.getFireSound() != null) {
            world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, bulletEffect.getFireSound(), SoundCategory.PLAYERS, RandUtil.nextFloat(0.95f, 1.1f), RandUtil.nextFloat(0.95f, 1.1f), false);
        }
        if (!player.func_184812_l_()) {
            this.takeEffectsFromItem(stack, consumed);
        }
        this.setFireCooldown(world, player, stack);
        player.func_184609_a(hand);
        Vec3d normal = player.func_70676_i(0.0f);
        player.field_70159_w += -normal.field_72450_a * ((double)this.getBulletType((ItemStack)stack).knockbackStrength / 2.0);
        player.field_70181_x += -normal.field_72448_b * ((double)this.getBulletType((ItemStack)stack).knockbackStrength / 10.0);
        player.field_70179_y += -normal.field_72449_c * ((double)this.getBulletType((ItemStack)stack).knockbackStrength / 2.0);
        if (player.field_70125_A < (float)(-90 + this.headKnockStrength(stack))) {
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), 2.0f);
        }
        ClientRunnable.run((ClientRunnable)new ClientRunnable(){

            @SideOnly(value=Side.CLIENT)
            public void runIfClient() {
                EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
                if (clientPlayer == null) {
                    return;
                }
                BasicAnimation anim = new BasicAnimation((Object)clientPlayer, "rotationPitch");
                anim.setDuration(2.0f);
                anim.setTo((Object)Float.valueOf(Minecraft.func_71410_x().field_71439_g.field_70125_A - (float)IGunItem.this.headKnockStrength(stack)));
                anim.setEasing((Easing)Easing.easeInExpo);
                InternalHandler.INTERNAL_HANDLER.addTiltAnimation((Animation<?>)anim);
            }
        });
    }

    default public boolean reloadAmmo(World world, EntityPlayer player, ItemStack gun, ItemStack ammo) {
        if (!(ammo.func_77973_b() instanceof IAmmoItem) || ammo.func_77973_b() instanceof IGunItem) {
            return true;
        }
        IAmmoItem ammoItem = (IAmmoItem)ammo.func_77973_b();
        if (ammoItem.getBulletType(ammo) != this.getBulletType(gun)) {
            return true;
        }
        List<BulletEffect> gunAmmo = this.getEffectsFromItem(gun);
        if (!gunAmmo.isEmpty()) {
            return true;
        }
        List<BulletEffect> ammoBulletEffects = ((IAmmoItem)ammo.func_77973_b()).getEffectsFromItem(ammo);
        for (int index = 0; index < Math.min(ammoBulletEffects.size(), this.getMaxAmmo(gun)); ++index) {
            gunAmmo.add(ammoBulletEffects.get(index));
        }
        ammoItem.takeEffectsFromItem(ammo, Math.max(ammoBulletEffects.size(), this.getMaxAmmo(gun)));
        this.setEffects(gun, gunAmmo);
        this.setReloadCooldown(world, player, gun);
        return false;
    }

    default public void setFireCooldown(World world, EntityPlayer player, ItemStack stack) {
        SoundEvent[] events;
        if (this.getFireCooldownTime(stack) > 0) {
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.getFireCooldownTime(stack));
        }
        if (world.field_72995_K && this.getFireSoundEvents(stack) != null && (events = this.getFireSoundEvents(stack)) != null) {
            for (SoundEvent sound : events) {
                world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, RandUtil.nextFloat(3.0f, 4.0f), RandUtil.nextFloat(0.95f, 1.1f), false);
            }
        }
    }

    default public void setReloadCooldown(World world, EntityPlayer player, ItemStack stack) {
        if (this.getReloadCooldownTime(stack) <= 0) {
            return;
        }
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.getReloadCooldownTime(stack));
        if (world.field_72995_K && this.getReloadSoundEvent(stack) != null) {
            world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getReloadSoundEvent(stack), SoundCategory.PLAYERS, RandUtil.nextFloat(0.95f, 1.1f), RandUtil.nextFloat(0.95f, 1.1f), false);
        }
    }
}

