/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBulletEntity {
    @NotNull
    public Entity getAsEntity();

    @Nullable
    public EntityLivingBase getEntityThrower();

    @NotNull
    public Vec3d getPositionAsVector();

    @NotNull
    public BlockPos getPositionAsBlockPos();

    @NotNull
    public BulletType getBulletType();

    public double posX();

    public double posY();

    public double posZ();

    public double motionX();

    public double motionY();

    public double motionZ();

    public void setBulletType(@NotNull BulletType var1);

    @NotNull
    public BulletEffect getEffect();

    public void setEffect(@NotNull BulletEffect var1);

    public int getCasterId();

    public void setCasterId(int var1);

    public BlockPos getOrigin();

    public void setOrigin(BlockPos var1);

    public float getPotency();

    public void setPotency(float var1);

    default public double getBulletDistanceSq() {
        BlockPos origin = this.getOrigin();
        Vec3d pos = this.getPositionAsVector();
        return pos.func_186679_c((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p());
    }

    default public float getFalloff() {
        float potency;
        double dist = this.getBulletDistanceSq();
        return dist < (double)(potency = this.getPotency()) ? 0.0f : (float)((dist - (double)(potency * potency)) / (double)(4096.0f - potency * potency));
    }
}

