/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.utilities.client.TooltipHelper;
import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.EffectRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public interface IAmmoItem {
    @SideOnly(value=Side.CLIENT)
    default public void addTooltipContents(ItemStack stack, List<String> tooltip) {
        List<BulletEffect> bulletEffects = this.getEffectsFromItem(stack);
        for (int i = 0; i < bulletEffects.size(); ++i) {
            if (i > 5) {
                tooltip.add(TextFormatting.ITALIC.toString() + "... " + (bulletEffects.size() - 5) + "+");
                break;
            }
            TooltipHelper.addToTooltip(tooltip, (String)("shotgunsandglitter." + bulletEffects.get(i).getID() + ".name"), (Object[])new Object[0]);
        }
    }

    @NotNull
    default public List<BulletEffect> getEffectsFromItem(@NotNull ItemStack stack) {
        NBTTagList ammo = ItemNBTHelper.getList((ItemStack)stack, (String)"ammo", (int)8);
        if (ammo == null) {
            return Lists.newArrayList();
        }
        ArrayList bulletEffects = Lists.newArrayList();
        for (int i = 0; i < stack.func_190916_E(); ++i) {
            for (NBTBase effect : ammo) {
                bulletEffects.add(EffectRegistry.getBulletEffectByID(((NBTTagString)effect).func_150285_a_()));
            }
        }
        return bulletEffects;
    }

    default public void takeEffectsFromItem(@NotNull ItemStack stack, int n) {
        boolean canDestroy = this.destroyable(stack);
        NBTTagList ammo = ItemNBTHelper.getList((ItemStack)stack, (String)"ammo", (int)8);
        if (ammo == null) {
            if (canDestroy) {
                stack.func_190920_e(0);
            }
        } else {
            int size = this.getEffectsFromItem(stack).size();
            int toTake = n;
            if (canDestroy) {
                stack.func_190918_g(n / size);
                toTake = n % size;
            }
            if (!canDestroy || stack.func_190916_E() == 1) {
                for (int i = 0; i < toTake && !ammo.func_82582_d(); ++i) {
                    ammo.func_74744_a(0);
                }
                if (ammo.func_82582_d()) {
                    if (this.destroyable(stack)) {
                        stack.func_190920_e(0);
                    } else {
                        ItemNBTHelper.removeEntry((ItemStack)stack, (String)"ammo");
                    }
                }
            } else {
                stack.func_190918_g(1);
            }
        }
    }

    default public boolean destroyable(@NotNull ItemStack stack) {
        return true;
    }

    default public ItemStack fillEffects(ItemStack stack, BulletEffect bulletEffect) {
        this.setEffects(stack, (List<BulletEffect>)NonNullList.func_191197_a((int)this.getMaxAmmo(stack), (Object)bulletEffect));
        return stack;
    }

    default public ItemStack setEffects(ItemStack stack, List<BulletEffect> bulletEffects) {
        NBTTagList ammo = new NBTTagList();
        ItemNBTHelper.setList((ItemStack)stack, (String)"ammo", (NBTTagList)ammo);
        for (BulletEffect bulletEffect : bulletEffects) {
            if (ammo.func_74745_c() >= this.getMaxAmmo(stack)) break;
            ammo.func_74742_a((NBTBase)new NBTTagString(bulletEffect.getID()));
        }
        return stack;
    }

    public int getMaxAmmo(@NotNull ItemStack var1);

    default public int getMinAmmo(@NotNull ItemStack stack) {
        return 0;
    }

    @NotNull
    public BulletType getBulletType(@NotNull ItemStack var1);
}

