/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpFadeInOut;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.api.IGrenadeEntity;
import com.teamwizardry.shotgunsandglitter.api.InternalHandler;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import com.teamwizardry.shotgunsandglitter.client.core.ClientEventHandler;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class GrenadeEffectBasic
implements GrenadeEffect {
    @Override
    public String getID() {
        return "basic";
    }

    @Override
    public float range(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return 30.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpdate(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(InternalHandler.INTERNAL_HANDLER.getSparkle());
        glitter.setCollision(true);
        glitter.setScale(0.3f);
        glitter.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, 1.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(ClientEventHandler.SPARKLE);
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)grenade.getPositionAsVector()), (int)100, (int)0, (i, build) -> {
            build.setLifetime(RandUtil.nextInt(50, 100));
            build.setScale(RandUtil.nextFloat(0.2f, 3.0f));
            build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.1), 0.0));
            build.setAlphaFunction((InterpFunction)new InterpFadeInOut(0.0f, RandUtil.nextFloat(0.5f, 1.0f)));
            double radius = 6.0f * RandUtil.nextFloat();
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z));
        });
    }
}

