/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.teamwizardry.shotgunsandglitter.api.IGrenadeEntity;
import com.teamwizardry.shotgunsandglitter.common.core.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public interface GrenadeEffect {
    public String getID();

    default public void onImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        float range = this.range(world, grenade);
        for (EntityLivingBase target : world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(grenade.posX() - (double)range, grenade.posY() - (double)range, grenade.posZ() - (double)range, grenade.posX() + (double)range, grenade.posY() + (double)range, grenade.posZ() + (double)range), entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            Vec3d differenceVec = entity.func_174791_d().func_178788_d(grenade.getPositionAsVector());
            return differenceVec.func_189985_c() < (double)(range * range);
        })) {
            Vec3d difference = target.func_174791_d().func_178788_d(grenade.getPositionAsVector());
            this.hitEntity(world, grenade, (Entity)target, this.intensity(world, grenade, (float)difference.func_72433_c()));
        }
        if (this.doExplosionParticles(world, grenade)) {
            Explosion explosion = new Explosion(world, grenade.getAsEntity(), grenade.posX(), grenade.posY(), grenade.posZ(), 6.0f, false, false);
            explosion.func_77279_a(true);
            if (world.field_72995_K) {
                world.func_184134_a(grenade.posX(), grenade.posY(), grenade.posZ(), (SoundEvent)ModSounds.MAGIC_SPARKLE, SoundCategory.PLAYERS, 2.0f, 1.0f, false);
            }
        }
    }

    default public boolean doExplosionParticles(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return true;
    }

    default public void hitEntity(@NotNull World world, @NotNull IGrenadeEntity grenade, @NotNull Entity entity, float intensity) {
        if (!world.field_72995_K) {
            entity.func_70097_a(DamageSource.func_76356_a((Entity)grenade.getAsEntity(), (Entity)grenade.getEntityThrower()), this.damage(world, grenade, intensity));
            Vec3d repulsion = grenade.getPositionAsVector().func_178788_d(entity.func_174791_d());
            repulsion = repulsion.func_178786_a(0.0, repulsion.field_72448_b, 0.0).func_72432_b();
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70653_a(grenade.getAsEntity(), intensity, repulsion.field_72450_a, repulsion.field_72449_c);
            }
        }
    }

    default public void onUpdate(@NotNull World world, @NotNull IGrenadeEntity grenade) {
    }

    default public float lowerIntensityBound(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return 0.1f;
    }

    default public float intensity(@NotNull World world, @NotNull IGrenadeEntity grenade, float distance) {
        float lower = this.lowerIntensityBound(world, grenade);
        if (lower == 1.0f) {
            return 1.0f;
        }
        float cf = -lower / (lower - 1.0f);
        float d = distance / this.range(world, grenade);
        return 1.0f - d / (d + cf);
    }

    default public float range(@NotNull World world, @NotNull IGrenadeEntity grenade) {
        return 7.5f;
    }

    default public float damage(@NotNull World world, @NotNull IGrenadeEntity grenade, float intensity) {
        return 5.0f * intensity;
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderImpact(@NotNull World world, @NotNull IGrenadeEntity grenade) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderUpdate(@NotNull World world, @NotNull IGrenadeEntity grenade) {
    }
}

