/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.teamwizardry.shotgunsandglitter.api.BulletEffect;
import com.teamwizardry.shotgunsandglitter.api.BulletEffectBasic;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffect;
import com.teamwizardry.shotgunsandglitter.api.GrenadeEffectBasic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EffectRegistry {
    private static final HashMap<String, BulletEffect> BULLET_EFFECTS = new HashMap();
    private static final HashMap<String, GrenadeEffect> GRENADE_EFFECTS = new HashMap();
    private static final BulletEffect BASIC_BULLET_EFFECT = new BulletEffectBasic();
    private static final GrenadeEffect BASIC_GRENADE_EFFECT = new GrenadeEffectBasic();
    private static final List<BulletEffect> BULLET_EFFECTS_ORDERED = new ArrayList<BulletEffect>();
    private static final List<GrenadeEffect> GRENADE_EFFECTS_ORDERED = new ArrayList<GrenadeEffect>();

    public static void addEffect(BulletEffect ... bulletEffects) {
        for (BulletEffect bulletEffect : bulletEffects) {
            EffectRegistry.addEffect(bulletEffect);
        }
    }

    public static void addEffect(BulletEffect bulletEffect) {
        assert (!BULLET_EFFECTS.containsKey(bulletEffect.getID()));
        BULLET_EFFECTS.put(bulletEffect.getID(), bulletEffect);
        BULLET_EFFECTS_ORDERED.add(bulletEffect);
    }

    public static void addEffect(GrenadeEffect ... grenadeEffects) {
        for (GrenadeEffect grenadeEffect : grenadeEffects) {
            EffectRegistry.addEffect(grenadeEffect);
        }
    }

    public static void addEffect(GrenadeEffect grenadeEffect) {
        assert (!GRENADE_EFFECTS.containsKey(grenadeEffect.getID()));
        GRENADE_EFFECTS.put(grenadeEffect.getID(), grenadeEffect);
        GRENADE_EFFECTS_ORDERED.add(grenadeEffect);
    }

    public static List<BulletEffect> getBulletEffects() {
        return BULLET_EFFECTS_ORDERED;
    }

    public static List<GrenadeEffect> getGrenadeEffects() {
        return GRENADE_EFFECTS_ORDERED;
    }

    @NotNull
    public static BulletEffect getBulletEffectByID(String id) {
        return BULLET_EFFECTS.getOrDefault(id, BASIC_BULLET_EFFECT);
    }

    @NotNull
    public static GrenadeEffect getGrenadeEffectByID(String id) {
        return GRENADE_EFFECTS.getOrDefault(id, BASIC_GRENADE_EFFECT);
    }

    static {
        EffectRegistry.addEffect(BASIC_BULLET_EFFECT);
        EffectRegistry.addEffect(BASIC_GRENADE_EFFECT);
    }
}

