/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.shotgunsandglitter.api;

import com.teamwizardry.shotgunsandglitter.api.BulletType;
import com.teamwizardry.shotgunsandglitter.api.IBulletEntity;
import com.teamwizardry.shotgunsandglitter.api.util.RandUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BulletEffect {
    public String getID();

    default public void onImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
    }

    default public boolean onCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
        hitEntity.func_70097_a(DamageSource.func_76356_a((Entity)bullet.getAsEntity(), (Entity)bullet.getEntityThrower()), this.damage(world, bullet));
        if (hitEntity instanceof EntityLivingBase) {
            ((EntityLivingBase)hitEntity).func_70653_a(bullet.getAsEntity(), this.knockbackStrength(world, bullet), (double)MathHelper.func_76126_a((float)(bullet.getAsEntity().field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(bullet.getAsEntity().field_70177_z * ((float)Math.PI / 180)))));
        }
        return true;
    }

    default public boolean onCollideBlock(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull BlockPos pos, @NotNull IBlockState state) {
        return true;
    }

    default public void onUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
    }

    default public float getVelocity(@NotNull World world, @NotNull BulletType bulletType) {
        return 3.0f;
    }

    default public float damage(@NotNull World world, @NotNull IBulletEntity bullet) {
        return bullet.getBulletType().damage;
    }

    default public float knockbackStrength(@NotNull World world, @NotNull IBulletEntity bullet) {
        return bullet.getBulletType().knockbackStrength;
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderImpact(@NotNull World world, @NotNull IBulletEntity bullet) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderUpdate(@NotNull World world, @NotNull IBulletEntity bullet) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderCollideBlock(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull BlockPos pos, @NotNull IBlockState state) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderCollideEntity(@NotNull World world, @NotNull IBulletEntity bullet, @NotNull Entity hitEntity) {
    }

    @Nullable
    default public SoundEvent getFireSound() {
        return null;
    }

    @Nullable
    default public SoundEvent getImpactSound() {
        return null;
    }

    default public float getVolume() {
        return RandUtil.nextFloat(3.0f, 4.0f);
    }
}

