/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.worldmusic;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MusicWorldHelper {
    public static final int[] NUMBER_MAPPING = new int[]{2, 2, 4};
    public static final int NUMBERS = NUMBER_MAPPING.length;
    private static final int distanceLink = (int)Math.pow(100.0, 2.0);
    public static final int tickTiming = 100;
    private static final int _tickTiming = 103;
    private static Map<MusicInfo, NumberPart> musicMap = new LinkedHashMap<MusicInfo, NumberPart>();

    public static int nextPart(int number, int previous) {
        int maxParts = NUMBER_MAPPING[number - 1];
        if (++previous == maxParts) {
            previous = 0;
        }
        return previous;
    }

    public static NumberPartPlaying getNumberStep(World world, BlockPos position) {
        NumberPartPlaying thePart = null;
        int distanceSq = distanceLink;
        Iterator<Map.Entry<MusicInfo, NumberPart>> iterator = musicMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MusicInfo, NumberPart> mapping = iterator.next();
            MusicInfo info = mapping.getKey();
            long ticksAgo = world.func_82737_E() - info.tick;
            if (ticksAgo > 103L) {
                iterator.remove();
                continue;
            }
            double distanceSqThis = info.pos.func_177951_i((Vec3i)position);
            if (!(distanceSqThis < (double)distanceSq)) continue;
            distanceSq = (int)distanceSqThis;
            thePart = new NumberPartPlaying(mapping.getValue(), 100 - (int)ticksAgo);
        }
        if (thePart == null) {
            thePart = new NumberPartPlaying(new Random().nextInt(NUMBERS) + 1, -1, 0);
        }
        return thePart;
    }

    public static void logMap(World world, BlockPos playLocation, NumberPart nmbr) {
        musicMap.put(new MusicInfo(world.func_82737_E(), playLocation), nmbr);
    }

    private static class MusicInfo {
        private long tick;
        private BlockPos pos;

        private MusicInfo(long tick, BlockPos pos) {
            this.tick = tick;
            this.pos = pos;
        }
    }

    public static class NumberPart {
        public final int key;
        public final int part;

        public NumberPart(int key, int part) {
            this.key = key;
            this.part = part;
        }
    }

    public static class NumberPartPlaying
    extends NumberPart {
        public final int wait;

        public NumberPartPlaying(int key, int part, int wait) {
            super(key, part);
            this.wait = wait;
        }

        public NumberPartPlaying(NumberPart value, int wait) {
            super(value.key, value.part);
            this.wait = wait;
        }
    }
}

