/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.util;

import java.util.Optional;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapDecoration;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.Structure;

public class MapStructureHelper {
    public static ItemStack buildMapFor(Structure structure, World world, BlockPos from) {
        String target = structure.getClass().getSimpleName();
        Optional<BlockPos> blockPos = Registry.structureRegister.findClosestStructure(structure.getClass(), world, from, true);
        if (!blockPos.isPresent()) {
            System.err.println("### ### ### ###");
            System.err.println("WOW SOMETHING IS WRONG");
            System.err.println("No structure position found for " + target);
            System.err.println("### ### ### ###");
            return new ItemStack(Blocks.field_150484_ah);
        }
        return MapStructureHelper.buildMapFor(world, blockPos.get(), target.toLowerCase(), structure.getColor());
    }

    public static ItemStack buildMapFor(World world, BlockPos markerPlace, String name, int color) {
        ItemStack itemstack = ItemMap.func_190906_a((World)world, (double)markerPlace.func_177958_n(), (double)markerPlace.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
        ItemMap.func_190905_a((World)world, (ItemStack)itemstack);
        MapStructureHelper.addTargetDecoration(itemstack, markerPlace, MapDecoration.Type.TARGET_X, color);
        itemstack.func_190924_f("filled_map." + name);
        return itemstack;
    }

    private static void addTargetDecoration(ItemStack map, BlockPos target, MapDecoration.Type iconType, int color) {
        NBTTagList nbttaglist;
        if (map.func_77942_o() && map.func_77978_p() != null && map.func_77978_p().func_150297_b("Decorations", 9)) {
            nbttaglist = map.func_77978_p().func_150295_c("Decorations", 10);
        } else {
            nbttaglist = new NBTTagList();
            map.func_77983_a("Decorations", (NBTBase)nbttaglist);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74774_a("type", iconType.func_191163_a());
        nbttagcompound.func_74778_a("id", "+");
        nbttagcompound.func_74780_a("x", (double)target.func_177958_n());
        nbttagcompound.func_74780_a("z", (double)target.func_177952_p());
        nbttagcompound.func_74780_a("rot", 180.0);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        NBTTagCompound nbttagcompound1 = map.func_190925_c("display");
        nbttagcompound1.func_74768_a("MapColor", color);
    }
}

