/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.util;

import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DelayedTask
implements Runnable {
    private long delay;
    private Runnable function;
    private World world;

    public DelayedTask(Runnable function) {
        this(function, 20L);
    }

    public DelayedTask(Runnable function, long delay) {
        this.delay = delay;
        this.function = function;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (this.world == null) {
            this.world = event.world;
        }
        if (event.phase == TickEvent.Phase.START && event.world == this.world) {
            this.run();
        }
    }

    @Override
    public void run() {
        if (--this.delay < 0L) {
            this.function.run();
            this.destroy();
        }
    }

    protected void destroy() {
        this.function = () -> {};
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

