/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.BeachStructure;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.common.world.structure.VillageStructure1;
import net.modjam5.makercommunity.common.world.structure.VillageStructure2;
import net.modjam5.makercommunity.util.MapStructureHelper;

public class VillageStructure
extends MapGenStructure
implements Structure {
    private static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 11, 6, 11});
    private static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_76787_r);
    private int distance = 32;

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public String func_143025_a() {
        return "VillageIsland";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_76787_r ? null : VillageStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387312);
        k *= this.distance;
        l *= this.distance;
        if (i == (k += random.nextInt(this.distance - 8)) && j == (l += random.nextInt(this.distance - 8)) && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, MapGenVillage.field_75055_e))) {
            return random.nextBoolean();
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        int height = world.func_72964_e(chunkX, chunkZ).func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF)) + 35;
        int j = height - 1;
        Entity zombie = EntityList.func_191304_a(EntityZombie.class, (World)world);
        if (zombie instanceof EntityZombie) {
            EntityZombie zomb = (EntityZombie)zombie;
            zomb.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemRegistry.recorders[0]));
            zomb.func_184642_a(EntityEquipmentSlot.HEAD, 100.0f);
            zomb.func_70012_b((double)i + 7.5, (double)j + 11.0, (double)k + 12.821350744582702, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            zomb.func_96094_a("XJ9");
            zomb.func_110163_bv();
            zomb.func_174805_g(false);
            world.func_72838_d((Entity)zomb);
        }
        BlockPos framePos = new BlockPos((double)i + 12.5, (double)j + 17.5, (double)(k + 8));
        EntityItemFrame entityitemframe = new EntityItemFrame(world, framePos, EnumFacing.SOUTH);
        entityitemframe.func_82334_a(MapStructureHelper.buildMapFor(Registry.structureRegister.byClass(BeachStructure.class), world, framePos));
        world.func_72838_d((Entity)entityitemframe);
        VillageStructure1.gen(world, i, j, k);
        VillageStructure2.gen(world, i, j, k);
    }
}

