/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.End1DeepStructure;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.util.EnchantingHelper;
import net.modjam5.makercommunity.util.MapStructureHelper;

public class SubHouseStructure
extends MapGenStructure
implements Structure {
    private static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 8, 8, 8});
    private static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_150575_M);

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public String func_143025_a() {
        return "SubHouse";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_76787_r ? null : SubHouseStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        if (Math.abs(chunkX) < 60 || Math.abs(chunkZ) < 60) {
            return false;
        }
        Random random = this.field_75039_c.func_72843_D(2304 * chunkX, 1996 * chunkZ, 811);
        boolean rand = random.nextInt(1000) + 1 <= 1;
        boolean biome = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 1, ALLOWED_BIOMES);
        return rand && biome;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    /*
     * Opcode count of 21155 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        int height;
        Block block;
        int y;
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (y = height = chunk.func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF)) - 1; y > 10 && ((block = chunk.func_186032_a(i, y, k).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i); --y) {
        }
        int j = (int)((double)y + (double)(height - y) / 2.0);
        BlockPos framePos = new BlockPos((double)i + 5.5, (double)j + 2.5, (double)k + 12.96875);
        EntityItemFrame entityitemframe = new EntityItemFrame(world, framePos, EnumFacing.NORTH);
        entityitemframe.func_82334_a(MapStructureHelper.buildMapFor(Registry.structureRegister.byClass(End1DeepStructure.class), world, framePos));
        world.func_72838_d((Entity)entityitemframe);
        EntitySkeleton skelly = new EntitySkeleton(world);
        skelly.func_70012_b((double)i + 5.5, (double)j + 1.0, (double)k + 8.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)skelly);
        skelly.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10));
        skelly.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemRegistry.recorders[6]));
        skelly.func_184201_a(EntityEquipmentSlot.CHEST, EnchantingHelper.withEnchants(new ItemStack((Item)Items.field_151163_ad), new Enchantment[]{Enchantments.field_180310_c, Enchantments.field_92091_k}, new int[]{5, 3}));
        skelly.func_184201_a(EntityEquipmentSlot.LEGS, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151173_ae), Enchantments.field_185297_d, 5));
        skelly.func_184201_a(EntityEquipmentSlot.FEET, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151175_af), Enchantments.field_180308_g, 5));
        skelly.func_184201_a(EntityEquipmentSlot.MAINHAND, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151031_f), Enchantments.field_185310_v, 10));
        skelly.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185166_h, (int)(Math.random() * 64.0)));
        skelly.func_184642_a(EntityEquipmentSlot.HEAD, 100.0f);
        skelly.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
        skelly.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
        skelly.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
        skelly.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        skelly.func_184642_a(EntityEquipmentSlot.OFFHAND, 100.0f);
        skelly.func_96094_a("Dinnerbone");
        skelly.func_110163_bv();
        skelly.func_174805_g(false);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 9), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 9), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 9), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 9), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 9), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 9), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 9), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 10), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 10), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 11), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 11), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 12), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 12), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 13), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 13), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 13), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 14), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 14), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 15), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 15), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 16), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 16), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 17), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 17), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 17), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 17), Block.func_149729_e((int)22).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 17), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 17), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 17), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 18), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 18), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 18), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 18), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 18), Block.func_149729_e((int)155).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 0), Block.func_149729_e((int)167).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 0), Block.func_149729_e((int)71).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 0), Block.func_149729_e((int)167).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 11), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 11), Block.func_149729_e((int)156).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 11), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 12), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 12), Block.func_149729_e((int)113).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 12), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 13), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 13), Block.func_149729_e((int)138).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 13), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 14), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 14), Block.func_149729_e((int)26).func_176203_a(10), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 14), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 15), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 15), Block.func_149729_e((int)26).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 15), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 0), Block.func_149729_e((int)167).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 0), Block.func_149729_e((int)71).func_176203_a(8), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 0), Block.func_149729_e((int)167).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 11), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 11), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 12), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 12), Block.func_149729_e((int)147).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 12), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 13), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 13), Block.func_149729_e((int)166).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 13), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 14), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 14), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 15), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 15), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 17), Block.func_149729_e((int)47).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 0), Block.func_149729_e((int)167).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 0), Block.func_149729_e((int)167).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 0), Block.func_149729_e((int)167).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 11), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 12), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 13), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 13), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 13), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 14), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 15), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 16), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 17), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 17), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 17), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 17), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 17), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 18), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 0), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 1), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 2), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 3), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 4), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 5), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 6), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 7), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 8), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 8), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 9), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 9), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 10), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 10), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 11), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 11), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 11), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 12), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 12), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 12), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 13), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 13), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 13), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 14), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 14), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 14), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 15), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 15), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 15), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 16), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 16), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 17), Block.func_149729_e((int)95).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(0), 2);
    }
}

