/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.modjam5.makercommunity.common.BlockRegistry;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.entity.EntityTriggerArmorStand;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.util.EnchantingHelper;
import net.modjam5.makercommunity.util.TippedArrowUtil;

public class EndStructure
extends MapGenStructure
implements Structure {
    private static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 8, 8, 8});
    private static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_150575_M);

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public String func_143025_a() {
        return "SubHouse";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.updateWorld(worldIn);
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_76787_r ? null : EndStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        return EndStructure.canSpawnStructureAtCoords(this.field_75039_c, chunkX, chunkZ);
    }

    public static boolean canSpawnStructureAtCoords(World world, int chunkX, int chunkZ) {
        if (Math.abs(chunkX) < 120 || Math.abs(chunkZ) < 120) {
            return false;
        }
        Random random = world.func_72843_D(2304 * chunkX, 1996 * chunkZ, 1337);
        boolean rand = random.nextInt(1000) + 1 <= 1;
        boolean biome = world.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 1, ALLOWED_BIOMES);
        return rand && biome;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    /*
     * Opcode count of 24393 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        Block block;
        int y;
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int cfr_ignored_0 = chunk.func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF)) - 1;
        for (y = chunk.func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF)) - 1; y > 10 && ((block = chunk.func_186032_a(i, y, k).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i); --y) {
        }
        int j = y;
        EntityElderGuardian elder = new EntityElderGuardian(world);
        elder.func_70012_b((double)i + 4.9987499713897705, (double)j + 2.0, (double)k + 15.293150894955033, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)elder);
        EntitySkeleton skelly = new EntitySkeleton(world);
        skelly.func_70012_b((double)i + 17.5, (double)(j + 2), (double)k + 18.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        skelly.func_184611_a(EnumHand.MAIN_HAND, EnchantingHelper.withEnchants(new ItemStack((Item)Items.field_151031_f), new Enchantment[]{Enchantments.field_185310_v, Enchantments.field_185309_u}, new int[]{5, 5}));
        skelly.func_184611_a(EnumHand.OFF_HAND, TippedArrowUtil.tippedArrow(PotionTypes.field_185218_A, new ArrayList<PotionEffect>()));
        world.func_72838_d((Entity)skelly);
        EntityTriggerArmorStand armorStand = new EntityTriggerArmorStand(world, i + 10, j + 6, k + 14);
        armorStand.setSummonOnTrigger(EntityElderGuardian.class);
        armorStand.setTickDelay(20L);
        armorStand.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)ItemRegistry.recorders[12]));
        armorStand.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemRegistry.recorders[13]));
        world.func_72838_d((Entity)armorStand);
        world.func_180501_a(new BlockPos(i + 14, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(5), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(5), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 0, k + 0), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(5), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 0, k + 1), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 0, k + 2), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 0, k + 3), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 0, k + 3), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 0, k + 4), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 0, k + 4), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 0, k + 22), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 0, k + 23), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 24), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 25), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 26), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 0, k + 27), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 0, k + 28), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 0, k + 29), Block.func_149729_e((int)1).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 2), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 2), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 4), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 7), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 11), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 12), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 13), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 14), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 15), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 16), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 16), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 16), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 16), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 16), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 17), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 17), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 17), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 17), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 17), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 18), Block.func_149729_e((int)97).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 22), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 25), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 27), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 27), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 1, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 1, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 1, k + 29), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 1, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 1, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 8), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 11), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 11), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 12), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 12), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 2, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 2, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 17), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 17), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 18), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 18), Block.func_149729_e((int)9).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 21), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 2, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 2, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 2, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 3, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 9), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 11), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 11), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 12), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 12), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 3, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 14), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 15), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 3, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 17), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 17), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 17), Block.func_149729_e((int)9).func_176203_a(8), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 17), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 18), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 18), Block.func_149729_e((int)9).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 18), Block.func_149729_e((int)0).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 19), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 20), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 3, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 3, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 3, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 4, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 10), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 4, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 14), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 15), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 16), Block.func_149729_e((int)9).func_176203_a(8), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 4, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 17), Block.func_149729_e((int)9).func_176203_a(8), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 18), Block.func_149729_e((int)9).func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 18), Block.func_149729_e((int)49).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 19), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 4, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 4, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 4, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 5, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 5, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 11), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 12), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 13), Block.func_149729_e((int)57).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 13), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 5, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 5, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 5, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 14), Block.func_149729_e((int)57).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 14), BlockRegistry.portal.func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 5, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 5, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 5, k + 14), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 15), Block.func_149729_e((int)57).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 15), BlockRegistry.portal.func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 5, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 5, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 5, k + 15), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 16), Block.func_149729_e((int)57).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 16), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 5, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 5, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 5, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 17), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 5, k + 18), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 5, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 5, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 5, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 6, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 6, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 6, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 6, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 6, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 6, k + 12), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 6, k + 13), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 6, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 14), Block.func_149729_e((int)57).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 6, k + 14), BlockRegistry.portal.func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 6, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 6, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 15), Block.func_149729_e((int)57).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 6, k + 15), BlockRegistry.portal.func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 6, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 6, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 6, k + 16), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 6, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 17, j + 6, k + 17), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 6, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 6, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 6, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 6, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 6, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 7, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 7, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 7, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 7, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 7, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 7, k + 13), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 7, k + 14), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 7, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 7, k + 15), Block.func_149729_e((int)251).func_176203_a(15), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 7, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 16, j + 7, k + 16), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 7, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 7, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 7, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 7, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 7, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 8, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 8, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 8, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 8, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 8, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 8, k + 14), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 8, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 9, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 10, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 11, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 12, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 13, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 14, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 15, j + 8, k + 15), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 8, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 8, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 8, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 8, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 8, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 9, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 9, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 9, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 9, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 9, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 9, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 9, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 9, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 9, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 9, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 10, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 10, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 10, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 10, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 10, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 10, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 10, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 10, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 10, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 10, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 11, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 11, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 11, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 11, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 11, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 11, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 11, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 11, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 11, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 11, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 11, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 11, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 11, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 11, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 11, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 11, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 11, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 11, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 0), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 1), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 1), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 1), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 1), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 2), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 2), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 2), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 2), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 3), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 3), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 3), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 3), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 4), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 25), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 26), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 26), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 26), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 26), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 27), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 27), Block.func_149729_e((int)41).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 27), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 27), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 28), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 28), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 28), Block.func_149729_e((int)168).func_176203_a(2), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 28), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 18, j + 12, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 19, j + 12, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 12, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 21, j + 12, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 22, j + 12, k + 29), Block.func_149729_e((int)168).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 13, k + 2), Block.func_149729_e((int)169).func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 20, j + 13, k + 27), Block.func_149729_e((int)169).func_176203_a(0), 2);
    }
}

