/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.AbstractDeepStructure;
import net.modjam5.makercommunity.common.world.structure.DeepHouseStructure;
import net.modjam5.makercommunity.util.MapStructureHelper;

public class DeepStructure
extends AbstractDeepStructure {
    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public String func_143025_a() {
        return "Deep";
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        if (Math.abs(chunkX) < 40 || Math.abs(chunkZ) < 40) {
            return false;
        }
        Random random = this.field_75039_c.func_72843_D(2304 * chunkX, 1996 * chunkZ, 905);
        boolean rand = random.nextInt(1000) + 1 <= 2;
        boolean biome = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 1, ALLOWED_BIOMES);
        return rand && biome;
    }

    @Override
    protected ItemStack holdingItem() {
        return new ItemStack((Item)ItemRegistry.recorders[4]);
    }

    @Override
    protected Class<? extends Entity> summonMob() {
        return EntityWither.class;
    }

    @Override
    protected ItemStack getMap(World world, BlockPos pos) {
        return MapStructureHelper.buildMapFor(Registry.structureRegister.byClass(DeepHouseStructure.class), world, pos);
    }
}

