/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.common.world.structure.SubHouseStructure;
import net.modjam5.makercommunity.util.EnchantingHelper;
import net.modjam5.makercommunity.util.MapStructureHelper;

public class DeepHouseStructure
extends MapGenStructure
implements Structure {
    private static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 8, 8, 8});
    private static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_150575_M);

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public String func_143025_a() {
        return "DeepHouse";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_76787_r ? null : DeepHouseStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        if (Math.abs(chunkX) < 50 || Math.abs(chunkZ) < 50) {
            return false;
        }
        Random random = this.field_75039_c.func_72843_D(2304 * chunkX, 1996 * chunkZ, 997);
        boolean rand = random.nextInt(1000) + 1 <= 2;
        boolean biome = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 1, ALLOWED_BIOMES);
        return rand && biome;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        Block block;
        int y;
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (y = chunk.func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF)) - 1; y > 10 && ((block = chunk.func_186032_a(i, y, k).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i); --y) {
        }
        int j = y;
        BlockPos framePos = new BlockPos((double)(i + 3), (double)j + 0.5, (double)k + 6.5);
        EntityItemFrame entityitemframe = new EntityItemFrame(world, framePos, EnumFacing.EAST);
        entityitemframe.func_82334_a(MapStructureHelper.buildMapFor(Registry.structureRegister.byClass(SubHouseStructure.class), world, framePos));
        world.func_72838_d((Entity)entityitemframe);
        EntityArmorStand armorStand = new EntityArmorStand(world, (double)i + 4.5, (double)(j + 1), (double)k + 4.5);
        armorStand.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)ItemRegistry.recorders[5]));
        world.func_72838_d((Entity)armorStand);
        EntityWitch witch = new EntityWitch(world);
        witch.func_70012_b((double)i + 4.5, (double)(j + 1), (double)k + 5.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)witch);
        witch.func_184201_a(EntityEquipmentSlot.HEAD, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151161_ac), Enchantments.field_180310_c, 3));
        witch.func_184201_a(EntityEquipmentSlot.CHEST, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151163_ad), Enchantments.field_180310_c, 3));
        witch.func_184201_a(EntityEquipmentSlot.LEGS, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151173_ae), Enchantments.field_180310_c, 3));
        witch.func_184201_a(EntityEquipmentSlot.FEET, EnchantingHelper.withEnchant(new ItemStack((Item)Items.field_151175_af), Enchantments.field_180310_c, 3));
        witch.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
        witch.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
        witch.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
        witch.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
        witch.func_96094_a("Kerman");
        witch.func_110163_bv();
        witch.func_174805_g(false);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 0), Block.func_149729_e((int)13).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 1), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 1), Block.func_149729_e((int)3).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 1), Block.func_149729_e((int)3).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 1), Block.func_149729_e((int)3).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 1), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 1), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 1), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 1), Block.func_149729_e((int)13).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 2), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 2), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 2), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 2), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 2), Block.func_149729_e((int)3).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 2), Block.func_149729_e((int)13).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 3), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 3), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 3), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 3), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 4), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 4), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 4), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 4), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 5), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 5), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 5), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 5), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 5), Block.func_149729_e((int)3).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 5), Block.func_149729_e((int)13).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 6), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 6), Block.func_149729_e((int)3).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 6), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 6), Block.func_149729_e((int)2).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 6), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 6), Block.func_149729_e((int)13).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 7), Block.func_149729_e((int)13).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 1), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 1), Block.func_149729_e((int)54).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 3), Block.func_149729_e((int)26).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 3), Block.func_149729_e((int)26).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 3), Block.func_149729_e((int)148).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 4), Block.func_149729_e((int)26).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 4), Block.func_149729_e((int)26).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 4), Block.func_149729_e((int)148).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 6), Block.func_149729_e((int)54).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 1), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 2), Block.func_149729_e((int)108).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 3), Block.func_149729_e((int)9).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 4), Block.func_149729_e((int)9).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 5), Block.func_149729_e((int)108).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 1), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 2), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 2), Block.func_149729_e((int)169).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 2), Block.func_149729_e((int)169).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 3), Block.func_149729_e((int)108).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 4), Block.func_149729_e((int)108).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 5), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 5), Block.func_149729_e((int)169).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 5), Block.func_149729_e((int)169).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 6), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 2), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 3), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 3), Block.func_149729_e((int)54).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 4), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 4), Block.func_149729_e((int)54).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 5), Block.func_149729_e((int)47).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 0), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 6, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 6, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 6, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 6, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 6, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 0), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 0), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 1), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 1), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 1), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 2), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 2), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 3), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 4), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 4), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 5), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 5), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 5), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 6), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 6), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 6), Block.func_149729_e((int)9).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 7, k + 7), Block.func_149729_e((int)9).func_176203_a(0), 3);
    }
}

