/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.DeepStructure;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.util.MapStructureHelper;
import net.modjam5.makercommunity.util.ScubaHelmetHelper;

public class BoatStructure
extends MapGenStructure
implements Structure {
    private static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 7, 10, 17});
    private static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_76771_b);

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public String func_143025_a() {
        return "Boat";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_76787_r ? null : BoatStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        if (Math.abs(chunkX) < 30 || Math.abs(chunkZ) < 30) {
            return false;
        }
        Random random = this.field_75039_c.func_72843_D(2304 * chunkX, 1996 * chunkZ, 905);
        boolean rand = random.nextInt(1000) + 1 <= 2;
        boolean biome = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 1, ALLOWED_BIOMES);
        return rand && biome;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        int height = world.func_72964_e(chunkX, chunkZ).func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF));
        int j = height - this.getBoundingBox().field_78894_e;
        EntityIllusionIllager illusionIllager = new EntityIllusionIllager(world);
        illusionIllager.func_82142_c(true);
        illusionIllager.func_70012_b((double)(i + 4), (double)j + 10.0, (double)(k + 15), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)illusionIllager);
        illusionIllager.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac));
        illusionIllager.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151163_ad));
        illusionIllager.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151173_ae));
        illusionIllager.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151175_af));
        illusionIllager.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)ItemRegistry.recorders[2]));
        illusionIllager.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
        illusionIllager.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
        illusionIllager.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
        illusionIllager.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
        illusionIllager.func_184642_a(EntityEquipmentSlot.OFFHAND, 100.0f);
        illusionIllager.func_96094_a("NED");
        illusionIllager.func_110163_bv();
        illusionIllager.func_174805_g(false);
        BlockPos framePos = new BlockPos((double)i + 4.5, (double)j + 7.5, (double)(k + 10));
        EntityItemFrame entityitemframe = new EntityItemFrame(world, framePos, EnumFacing.SOUTH);
        entityitemframe.func_82334_a(MapStructureHelper.buildMapFor(Registry.structureRegister.byClass(DeepStructure.class), world, framePos));
        world.func_72838_d((Entity)entityitemframe);
        EntityArmorStand armorStand = new EntityArmorStand(world, (double)i + 4.5, (double)(j + -1), (double)(k + 10));
        armorStand.func_184201_a(EntityEquipmentSlot.HEAD, ScubaHelmetHelper.scuba());
        armorStand.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)ItemRegistry.recorders[3]));
        world.func_72838_d((Entity)armorStand);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 8), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 8), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 8), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 8), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 8), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 9), Block.func_149729_e((int)35).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 9), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 9), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 9), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 0), Block.func_149729_e((int)126).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 1), Block.func_149729_e((int)126).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 2), Block.func_149729_e((int)126).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 3), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 3), Block.func_149729_e((int)126).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 3), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 4), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 4), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 5), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 5), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 6), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 6), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 9), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 13), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 13), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 14), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 14), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 7, k + 15), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 7, k + 15), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 7, k + 15), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 7, k + 15), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 7, k + 16), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 3), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 8, k + 3), Block.func_149729_e((int)53).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 3), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 4), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 4), Block.func_149729_e((int)53).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 5), Block.func_149729_e((int)53).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 5), Block.func_149729_e((int)53).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 6), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 6), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 7), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 7), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 8), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 8), Block.func_149729_e((int)19).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 8), Block.func_149729_e((int)19).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 8), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 9), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 9), Block.func_149729_e((int)19).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 8, k + 9), Block.func_149729_e((int)5).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 9), Block.func_149729_e((int)19).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 9), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 10), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 10), Block.func_149729_e((int)19).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 10), Block.func_149729_e((int)19).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 10), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 11), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 11), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 12), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 12), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 13), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 13), Block.func_149729_e((int)23).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 13), Block.func_149729_e((int)23).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 13), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 14), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 14), Block.func_149729_e((int)23).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 14), Block.func_149729_e((int)23).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 14), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 8, k + 15), Block.func_149729_e((int)53).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 8, k + 15), Block.func_149729_e((int)5).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 8, k + 15), Block.func_149729_e((int)5).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 8, k + 15), Block.func_149729_e((int)5).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 8, k + 15), Block.func_149729_e((int)53).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 8, k + 16), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 4), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 5), Block.func_149729_e((int)53).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 5), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 5), Block.func_149729_e((int)53).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 6), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 6), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 6), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 7), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 7), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 7), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 8), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 8), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 8), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 9), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 9), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 9), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 10), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 10), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 10), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 11), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 11), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 11), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 12), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 12), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 12), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 13), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 13), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 13), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 14), Block.func_149729_e((int)53).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 14), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 14), Block.func_149729_e((int)53).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 9, k + 15), Block.func_149729_e((int)53).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 15), Block.func_149729_e((int)53).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 9, k + 15), Block.func_149729_e((int)53).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 9, k + 16), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 10, k + 16), Block.func_149729_e((int)85).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 10, k + 17), Block.func_149729_e((int)5).func_176203_a(0), 3);
    }
}

