/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.modjam5.makercommunity.common.ItemRegistry;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.structure.BoatStructure;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.util.MapStructureHelper;

public class BeachStructure
extends MapGenStructure
implements Structure {
    private static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 11, 6, 11});
    private static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_76787_r);

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.canSpawnStructureAtCoords2(chunkX, chunkZ);
    }

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public String func_143025_a() {
        return "BeachHouse";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_76787_r ? null : BeachStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public boolean canSpawnStructureAtCoords2(int chunkX, int chunkZ) {
        if (Math.abs(chunkX) < 20 || Math.abs(chunkZ) < 20) {
            return false;
        }
        Random random = this.field_75039_c.func_72843_D(2304 * chunkX, 1996 * chunkZ, 905);
        boolean rand = random.nextInt(100) + 1 <= 5;
        boolean biome = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 4, ALLOWED_BIOMES);
        return rand && biome;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    /*
     * Opcode count of 14671 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        TileEntityChest chestTE;
        IItemHandler iItemHandler;
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        int height = world.func_72964_e(chunkX, chunkZ).func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF));
        int j = height - 1;
        BlockPos chest = new BlockPos(i + 5, j + 2, k + 5);
        world.func_180501_a(chest, Blocks.field_150486_ae.func_176223_P(), 3);
        TileEntity te = world.func_175625_s(chest);
        if (te instanceof TileEntityChest && (iItemHandler = (IItemHandler)(chestTE = (TileEntityChest)te).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            iItemHandler.insertItem(world.field_73012_v.nextInt(chestTE.func_70302_i_()), MapStructureHelper.buildMapFor(Registry.structureRegister.byClass(BoatStructure.class), world, chest), false);
        }
        EntityZombieVillager villager = new EntityZombieVillager(world);
        villager.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemRegistry.recorders[1]));
        villager.func_184642_a(EntityEquipmentSlot.HEAD, 100.0f);
        villager.func_82227_f(true);
        villager.func_110163_bv();
        villager.func_70012_b((double)(i + 5), (double)(j + 3), (double)(k + 5), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        villager.func_96094_a("XJ1");
        villager.func_110149_m(10.0f);
        villager.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 16383, 1, false, true));
        villager.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 16383, 0, false, true));
        villager.func_174805_g(false);
        world.func_72838_d((Entity)villager);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 1), Block.func_149729_e((int)135).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 1), Block.func_149729_e((int)135).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 1), Block.func_149729_e((int)135).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 1), Block.func_149729_e((int)135).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 1), Block.func_149729_e((int)135).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 1), Block.func_149729_e((int)135).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 2), Block.func_149729_e((int)135).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 2), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 2), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 2), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 2), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 2), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 2), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 2), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 2), Block.func_149729_e((int)135).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 3), Block.func_149729_e((int)135).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 3), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 3), Block.func_149729_e((int)125).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 3), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 3), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 3), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 3), Block.func_149729_e((int)125).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 3), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 3), Block.func_149729_e((int)135).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 4), Block.func_149729_e((int)135).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 4), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 4), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 4), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 4), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 4), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 4), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 4), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 4), Block.func_149729_e((int)135).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 6), Block.func_149729_e((int)135).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 6), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 6), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 6), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 6), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 6), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 6), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 6), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 6), Block.func_149729_e((int)135).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 7), Block.func_149729_e((int)135).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 7), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 7), Block.func_149729_e((int)125).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 7), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 7), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 7), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 7), Block.func_149729_e((int)125).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 7), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 7), Block.func_149729_e((int)135).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 8), Block.func_149729_e((int)135).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 8), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 8), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 8), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 8), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 8), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 8), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 8), Block.func_149729_e((int)126).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 8), Block.func_149729_e((int)135).func_176203_a(6), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 9), Block.func_149729_e((int)135).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 9), Block.func_149729_e((int)135).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 9), Block.func_149729_e((int)135).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 9), Block.func_149729_e((int)135).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 9), Block.func_149729_e((int)135).func_176203_a(7), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 9), Block.func_149729_e((int)135).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 0, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 2), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 2), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 3), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 3), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 4), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 4), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 6), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 6), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 7), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 7), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 8), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 8), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 1, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 3), Block.func_149729_e((int)69).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 3), Block.func_149729_e((int)69).func_176203_a(10), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 3), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 4), Block.func_149729_e((int)69).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 4), Block.func_149729_e((int)75).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 4), Block.func_149729_e((int)69).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 4), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 5), Block.func_149729_e((int)75).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 5), Block.func_149729_e((int)75).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 6), Block.func_149729_e((int)69).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 6), Block.func_149729_e((int)75).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 6), Block.func_149729_e((int)69).func_176203_a(4), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 6), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 7), Block.func_149729_e((int)69).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 7), Block.func_149729_e((int)69).func_176203_a(10), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 7), Block.func_149729_e((int)42).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 8), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 8), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 2, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 1), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 2), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 3), Block.func_149729_e((int)75).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 3), Block.func_149729_e((int)75).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 3), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 4), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 4), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 5), Block.func_149729_e((int)17).func_176203_a(8), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 6), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 6), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 7), Block.func_149729_e((int)75).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 7), Block.func_149729_e((int)75).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 7), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 8), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 8), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 9), Block.func_149729_e((int)20).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 3, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 0), Block.func_149729_e((int)134).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 1), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 1), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 1), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 2), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 2), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 2), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 2), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 3), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 3), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 3), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 3), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 4), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 4), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 4), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 4), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 5), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 5), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 5), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 6), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 6), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 6), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 6), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 7), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 7), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 7), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 7), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 8), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 8), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 8), Block.func_149729_e((int)17).func_176203_a(9), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 8), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 9), Block.func_149729_e((int)134).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(5), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 9), Block.func_149729_e((int)17).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 9), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 4, k + 10), Block.func_149729_e((int)134).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 0), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 1), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 1), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 2), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 2), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 3), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 3), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 4), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 4), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 5), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 5), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 6), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 6), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 7), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 7), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 8), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 8), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 9), Block.func_149729_e((int)126).func_176203_a(1), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 9), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 0, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 6, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 8, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 10, j + 5, k + 10), Block.func_149729_e((int)0).func_176203_a(0), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 1, k + 5), Block.func_149729_e((int)194).func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(i + 9, j + 2, k + 5), Block.func_149729_e((int)194).func_176203_a(8), 3);
    }
}

