/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.modjam5.makercommunity.common.entity.EntityTriggerArmorStand;
import net.modjam5.makercommunity.common.world.structure.Structure;

public abstract class AbstractDeepStructure
extends MapGenStructure
implements Structure {
    protected static final StructureBoundingBox boundingBox = new StructureBoundingBox(new int[]{0, 0, 0, 1, 2, 1});
    protected static final List<Biome> ALLOWED_BIOMES = Collections.singletonList(Biomes.field_150575_M);

    @Override
    public void updateWorld(World world) {
        this.field_75039_c = world;
    }

    @Override
    public StructureBoundingBox getBoundingBox() {
        return boundingBox;
    }

    public abstract String func_143025_a();

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.updateWorld(worldIn);
        return AbstractDeepStructure.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    @Override
    public abstract boolean canSpawnStructureAtCoords2(int var1, int var2);

    protected abstract ItemStack holdingItem();

    protected abstract Class<? extends Entity> summonMob();

    protected abstract ItemStack getMap(World var1, BlockPos var2);

    protected IBlockState mainBlock() {
        return Blocks.field_150428_aP.func_176223_P();
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Structure.Start(this, chunkX, chunkZ);
    }

    @Override
    public void generate(World world, Random random, int xPos, int zPos) {
        Block block;
        int y;
        int i = xPos + random.nextInt(15);
        int k = zPos + random.nextInt(15);
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        for (y = chunk.func_177433_f(new BlockPos(i & 0xF, 0, k & 0xF)) - 1; y > 10 && ((block = chunk.func_186032_a(i, y, k).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i); --y) {
        }
        int j = y + 1;
        BlockPos framePos = new BlockPos(i + 1, j, k);
        EntityItemFrame entityitemframe = new EntityItemFrame(world, framePos, EnumFacing.EAST);
        entityitemframe.func_82334_a(this.getMap(world, framePos));
        world.func_72838_d((Entity)entityitemframe);
        EntityTriggerArmorStand armorStand = new EntityTriggerArmorStand(world, (double)i + 0.5, j + 1, (double)k + 0.5);
        armorStand.setSummonOnTrigger(this.summonMob());
        armorStand.setTickDelay(200L);
        armorStand.func_184201_a(EntityEquipmentSlot.MAINHAND, this.holdingItem());
        world.func_72838_d((Entity)armorStand);
        world.func_180501_a(new BlockPos(i, j, k), this.mainBlock(), 3);
        world.func_180501_a(new BlockPos(i, j + 1, k), Blocks.field_150350_a.func_176203_a(0), 10);
        world.func_180501_a(new BlockPos(i, j + 2, k), Blocks.field_150350_a.func_176203_a(0), 10);
    }
}

