/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.world;

import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.modjam5.makercommunity.common.world.structure.BeachStructure;
import net.modjam5.makercommunity.common.world.structure.BoatStructure;
import net.modjam5.makercommunity.common.world.structure.DeepHouseStructure;
import net.modjam5.makercommunity.common.world.structure.DeepStructure;
import net.modjam5.makercommunity.common.world.structure.End1DeepStructure;
import net.modjam5.makercommunity.common.world.structure.End2DeepStructure;
import net.modjam5.makercommunity.common.world.structure.End3DeepStructure;
import net.modjam5.makercommunity.common.world.structure.End4DeepStructure;
import net.modjam5.makercommunity.common.world.structure.End5DeepStructure;
import net.modjam5.makercommunity.common.world.structure.EndStructure;
import net.modjam5.makercommunity.common.world.structure.Structure;
import net.modjam5.makercommunity.common.world.structure.SubHouseStructure;
import net.modjam5.makercommunity.common.world.structure.VillageStructure;

public class StructureRegister
implements IWorldGenerator {
    public static final Class<? extends Structure>[] classes = new Class[]{BeachStructure.class, VillageStructure.class, BoatStructure.class, DeepStructure.class, DeepHouseStructure.class, SubHouseStructure.class, End1DeepStructure.class, End2DeepStructure.class, End3DeepStructure.class, End4DeepStructure.class, End5DeepStructure.class, EndStructure.class};
    private Structure[] structures = new Structure[classes.length];

    public StructureRegister() {
        for (int i = 0; i < classes.length; ++i) {
            try {
                this.structures[i] = classes[i].newInstance();
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public Structure byClass(Class<? extends Structure> cls) {
        for (Structure structure : this.structures) {
            if (structure.getClass() != cls) continue;
            return structure;
        }
        throw new RuntimeException("DIDN'T REGISTER " + cls);
    }

    public static Optional<Class<? extends Structure>> findClassByName(String name) {
        return Arrays.stream(classes).filter(cls -> cls.getSimpleName().equals(name)).findFirst();
    }

    public Optional<BlockPos> findClosestStructure(Class<? extends Structure> structureClass, World world, BlockPos pos, boolean unvisited) {
        Optional<BlockPos> optionalBlockPos = Optional.empty();
        for (Structure structure : this.structures) {
            if (structure.getClass() != structureClass || !(structure instanceof MapGenStructure)) continue;
            optionalBlockPos = Optional.ofNullable(((MapGenStructure)structure).func_180706_b(world, pos, unvisited));
        }
        return optionalBlockPos;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        for (Structure structure : this.structures) {
            structure.updateWorld(world);
            if (!structure.canSpawnStructureAtCoords2(chunkX, chunkZ)) continue;
            structure.generate(world, random, x, z);
        }
    }
}

