/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.modjam5.makercommunity.util.DelayedTask;

public class EntityTriggerArmorStand
extends EntityArmorStand {
    private Class<? extends Entity> summonOnTrigger = null;
    private long tickDelay = 0L;

    public EntityTriggerArmorStand(World worldIn) {
        this(worldIn, 0.0, 0.0, 0.0);
    }

    public EntityTriggerArmorStand(World worldIn, double posX, double posY, double posZ) {
        super(worldIn, posX, posY, posZ);
        this.func_184224_h(true);
    }

    public Class<? extends Entity> getSummonOnTrigger() {
        return this.summonOnTrigger;
    }

    public void setSummonOnTrigger(Class<? extends Entity> summonOnTrigger) {
        this.summonOnTrigger = summonOnTrigger;
    }

    public long getTickDelay() {
        return this.tickDelay;
    }

    public void setTickDelay(long tickDelay) {
        this.tickDelay = tickDelay;
    }

    public void trigger() {
        BlockPos pos = this.func_180425_c();
        this.dropContents();
        if (this.summonOnTrigger != null) {
            Runnable run = () -> {
                this.field_70170_p.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_193794_eP, SoundCategory.HOSTILE, 1.0f, 1.0f, true);
                Entity entity = EntityList.func_191304_a(this.summonOnTrigger, (World)this.field_70170_p);
                if (entity == null) {
                    return;
                }
                entity.func_70012_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70170_p.func_72838_d(entity);
            };
            if (this.tickDelay > 0L) {
                new DelayedTask(run, this.tickDelay);
            } else {
                run.run();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.trigger();
        return false;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        this.trigger();
        return EnumActionResult.SUCCESS;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("triggered")) {
            try {
                this.summonOnTrigger = Class.forName(compound.func_74779_i("triggered"));
            }
            catch (ClassCastException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("delayed")) {
            this.tickDelay = compound.func_74763_f("delayed");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.summonOnTrigger != null) {
            compound.func_74778_a("triggered", this.summonOnTrigger.getName());
        }
        compound.func_74772_a("delayed", this.tickDelay);
    }

    private void dropContents() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
        this.func_184209_aF().forEach(itemStack -> Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this).func_177984_a(), (ItemStack)itemStack));
        this.func_70106_y();
    }
}

