/*
 * Decompiled with CFR 0.152.
 */
package net.modjam5.makercommunity.common.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.modjam5.makercommunity.common.Registry;
import net.modjam5.makercommunity.common.world.StructureRegister;
import net.modjam5.makercommunity.common.world.structure.Structure;

public class LocateSubMineOfThieves
extends CommandBase {
    public String func_71517_b() {
        return "LocateSubMineOfThieves".toLowerCase();
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.submineofthieves.locate.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Optional<Class<? extends Structure>> structureClass;
        if (args.length == 0) {
            throw new WrongUsageException("1 argument needed", new Object[0]);
        }
        String structure = args[0];
        boolean unvisited = true;
        if (args.length >= 2) {
            unvisited = LocateSubMineOfThieves.func_180527_d((String)args[1]);
        }
        if (!(structureClass = StructureRegister.findClassByName(structure)).isPresent()) {
            throw new WrongUsageException("No class found by name " + structure, new Object[0]);
        }
        Optional<BlockPos> pos = Registry.structureRegister.findClosestStructure(structureClass.get(), sender.func_130014_f_(), sender.func_180425_c(), unvisited);
        if (!pos.isPresent()) {
            throw new CommandException("commands.locate.failure", new Object[]{structure});
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.locate.success", new Object[]{structure, pos.get().func_177958_n(), pos.get().func_177952_p()}));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 0: 
            case 1: {
                return LocateSubMineOfThieves.func_175762_a((String[])args, (Collection)Arrays.stream(StructureRegister.classes).map(Class::getSimpleName).collect(Collectors.toList()));
            }
            case 2: {
                LocateSubMineOfThieves.func_175762_a((String[])args, Arrays.asList("true", "false"));
            }
        }
        return Collections.emptyList();
    }
}

