/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.client.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderingUtils {
    public static Minecraft mc = Minecraft.func_71410_x();

    public static void render3DItem(EntityItem item, float angle) {
        GL11.glPushMatrix();
        item.field_70290_d = 0.0f;
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        mc.func_175598_ae().func_188391_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        GL11.glPopMatrix();
    }

    private static void setupGlTranslucent() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    private static void renderTranslucent(BufferBuilder vertex, double startX, double startY, double startZ, double endX, double endY, double endZ, double rotationX, double rotationY, double rotationZ) {
        GL11.glPushMatrix();
        GL11.glRotated((double)rotationX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotationY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotationZ, (double)0.0, (double)0.0, (double)1.0);
        GL11.glPushMatrix();
        for (int j = 0; j < 4; ++j) {
            RenderingUtils.drawTranslucent(vertex, startX, startY, startZ, endX, endY, endZ);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private static void drawTranslucent(BufferBuilder vertex, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        vertex.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertex.func_181662_b(-startX, startY, -startZ).func_181669_b(100, 0, 0, 255).func_181675_d();
        vertex.func_181662_b(startX, startY, -startZ).func_181669_b(0, 100, 0, 255).func_181675_d();
        vertex.func_181662_b(endX, endY, -endZ).func_181669_b(0, 0, 100, 255).func_181675_d();
        vertex.func_181662_b(-endX, endY, -endZ).func_181669_b(40, 20, 255, 255).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderBeamAt(Entity entity, double startX, double startY, double startZ, double endX, double endY, double endZ, double rotationX, double rotationY, double rotationZ) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)startX, (double)startY, (double)startZ);
        GL11.glPushAttrib((int)1048575);
        RenderingUtils.setupGlTranslucent();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertex = tessellator.func_178180_c();
        RenderingUtils.renderTranslucent(vertex, startX, startY, startZ, endX, endY, endZ, rotationX, rotationY, rotationZ);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double x2, double y2, float red, float green, float blue, float lineWidth) {
        int existed = ClientHelper.player().field_70173_aa;
        float alpha = 0.3f + MathHelper.func_76126_a((float)((float)((double)existed + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double z, double x2, double y2, double z2, float red, float green, float blue, float lineWidth) {
        int count = ClientHelper.player().field_70173_aa;
        float alpha = 0.3f + MathHelper.func_76126_a((float)((float)((double)count + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawLineNoFade(double x, double y, double x2, double y2, float red, float green, float blue, float lineWidth, float alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawLineNoFade(double x, double y, double z, double x2, double y2, double z2, float red, float green, float blue, float lineWidth, float alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double x2, double y2, float red, float green, float blue, float lineWidth, float fadeSpeed) {
        int count = ClientHelper.player().field_70173_aa;
        float alpha = fadeSpeed + MathHelper.func_76126_a((float)((float)((double)count + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double z, double x2, double y2, double z2, float red, float green, float blue, float lineWidth, float fadeSpeed) {
        int existed = ClientHelper.player().field_70173_aa;
        float alpha = 0.3f + MathHelper.func_76126_a((float)((float)((double)existed + x))) * 0.3f + 0.3f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawRect(double x, double y, double width, double height, float red, float green, float blue, float lineWidth) {
        RenderingUtils.drawLine(x, y, x + width, y, red, green, blue, lineWidth, 0.0f);
        RenderingUtils.drawLine(x + width, y, x + width, y + width, red, green, blue, lineWidth, 0.0f);
        RenderingUtils.drawLine(x + width, y + width, x, y + width, red, green, blue, lineWidth, 0.0f);
        RenderingUtils.drawLine(x, y + width, x, y, red, green, blue, lineWidth, 0.0f);
    }

    public static void drawRectFadeless(double x, double y, double width, double height, float red, float green, float blue, float lineWidth, float alpha) {
        RenderingUtils.drawLineNoFade(x, y, x + width, y, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y, x + width, y + width, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y + width, x, y + width, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x, y + width, x, y, red, green, blue, lineWidth, alpha);
    }

    public static void drawRect(double x, double y, double width, double height, float red, float green, float blue, float lineWidth, float fadeSpeed) {
        RenderingUtils.drawLine(x, y, x + width, y, red, green, blue, lineWidth, fadeSpeed);
        RenderingUtils.drawLine(x + width, y, x + width, y + width, red, green, blue, lineWidth, fadeSpeed);
        RenderingUtils.drawLine(x + width, y + width, x, y + width, red, green, blue, lineWidth, fadeSpeed);
        RenderingUtils.drawLine(x, y + width, x, y, red, green, blue, lineWidth, fadeSpeed);
    }

    public static void drawRect(double x, double y, double z, double width, double height, float red, float green, float blue, float lineWidth) {
        RenderingUtils.drawLine(x, y, z, x + width, y, z, red, green, blue, lineWidth);
        RenderingUtils.drawLine(x + width, y, z, x + width, y + width, z, red, green, blue, lineWidth);
        RenderingUtils.drawLine(x + width, y + width, z, x, y + width, z, red, green, blue, lineWidth);
        RenderingUtils.drawLine(x, y + width, z, x, y, z, red, green, blue, lineWidth);
    }

    public static void drawRectNoFade(double x, double y, double z, double width, double height, float red, float green, float blue, float lineWidth, float alpha) {
        RenderingUtils.drawLineNoFade(x, y, z, x + width, y, z, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y, z, x + width, y + width, z, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x + width, y + width, z, x, y + width, z, red, green, blue, lineWidth, alpha);
        RenderingUtils.drawLineNoFade(x, y + width, z, x, y, z, red, green, blue, lineWidth, alpha);
    }
}

