/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.IBaseMod;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;

public class Platform {
    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isSameItemIgnoreNBT(@Nullable ItemStack itemStack1, @Nullable ItemStack itemStack2) {
        return itemStack1 != null && itemStack2 != null && itemStack1.func_77969_a(itemStack2);
    }

    public static boolean isSameItemWithNBT(@Nullable ItemStack itemStack1, @Nullable ItemStack itemStack2) {
        return itemStack1 != null && itemStack2 != null && itemStack1.func_77969_a(itemStack2) && ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2);
    }

    public static EnumFacing rotateAround(EnumFacing forward) {
        switch (forward) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return forward;
    }

    public static boolean isDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static boolean generateBaseTextures() {
        return Platform.getArgumentList().contains("generateBaseTextures");
    }

    public static ArrayList getArgumentList() {
        return (ArrayList)Launch.blackboard.get("ArgumentList");
    }

    public static IBaseMod getCurrentMod() {
        Object activeMod = Loader.instance().activeModContainer().getMod();
        if (activeMod instanceof IBaseMod) {
            return (IBaseMod)activeMod;
        }
        FMLLog.bigWarning((String)"Mods using BASE must have their mod class extend IBaseMod!", (Object[])new Object[]{""});
        return null;
    }

    public static void attemptLogErrorToCurrentMod(String logString) {
        IBaseMod mod = Platform.getCurrentMod();
        if (mod != null) {
            mod.getLogger().error(logString);
        }
    }

    public static void attemptLogExceptionToCurrentMod(Throwable throwable) {
        IBaseMod mod = Platform.getCurrentMod();
        if (mod != null) {
            mod.getLogger().getLogger().error((Object)throwable);
        }
    }
}

