/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.tileentities;

import com.teamacronymcoders.base.blocks.properties.SideType;
import com.teamacronymcoders.base.client.IBlockOverlayText;
import com.teamacronymcoders.base.tileentities.TileEntityBase;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntitySidedBase
extends TileEntityBase
implements IBlockOverlayText {
    private SideType[] sideConfig = new SideType[6];
    private boolean isColorBlindActive;

    public TileEntitySidedBase() {
        Arrays.fill((Object[])this.sideConfig, (Object)SideType.NONE);
        this.isColorBlindActive = false;
    }

    public void toggleSide(int side) {
        this.sideConfig[side] = this.sideConfig[side].next();
        this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    public void setSideConfig(int side, SideType sideType) {
        this.sideConfig[side] = sideType;
    }

    public SideType getSideValue(int side) {
        return this.sideConfig[side];
    }

    @Override
    public void readFromDisk(NBTTagCompound data) {
        int[] array = data.func_74759_k("sideConfig");
        if (this.sideConfig == null) {
            this.sideConfig = new SideType[6];
        }
        for (int i = 0; i < array.length; ++i) {
            this.sideConfig[i] = SideType.values()[array[i]];
        }
    }

    @Override
    public NBTTagCompound writeToDisk(NBTTagCompound data) {
        int[] array = new int[6];
        for (int i = 0; i < this.sideConfig.length; ++i) {
            array[i] = this.sideConfig[i].ordinal();
        }
        data.func_74783_a("sideConfig", array);
        return data;
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), true);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getOverlayText(EntityPlayer player, RayTraceResult rayTrace, boolean tool) {
        if (tool && this.isColorBlindActive) {
            SideType facing = this.sideConfig[rayTrace.field_178784_b.ordinal()];
            SideType opposite = this.sideConfig[rayTrace.field_178784_b.func_176734_d().ordinal()];
            return new String[]{I18n.func_135052_a((String)"base.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("base.sidetype." + facing.name().toLowerCase()), (Object[])new Object[0]), I18n.func_135052_a((String)"base.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("base.sidetype." + opposite.name().toLowerCase()), (Object[])new Object[0])};
        }
        return null;
    }
}

