/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.registrysystem;

import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.registrysystem.Registry;
import com.teamacronymcoders.base.registrysystem.pieces.IRegistryPiece;
import com.teamacronymcoders.base.registrysystem.pieces.RegistryPieceComparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class ModularRegistry<ENTRY>
extends Registry<ENTRY> {
    private List<IRegistryPiece> registryPieces;

    public ModularRegistry(String name, IBaseMod mod, List<IRegistryPiece> registryPieces) {
        super(name, mod);
        this.registryPieces = registryPieces.stream().filter(registryPiece -> registryPiece.acceptsRegistry(this)).collect(Collectors.toList());
        this.registryPieces.sort(new RegistryPieceComparator());
    }

    @Override
    public void preInit() {
        super.preInit();
        this.entries.forEach((entryName, entryValue) -> this.registryPieces.stream().filter(registryPiece -> registryPiece.acceptsEntry((ResourceLocation)entryName, entryValue)).forEach(registryPiece -> registryPiece.preInit((ResourceLocation)entryName, entryValue)));
    }

    @Override
    public void registryEvent() {
        super.registryEvent();
        this.entries.forEach((entryName, entryValue) -> this.registryPieces.stream().filter(registryPiece -> registryPiece.acceptsEntry((ResourceLocation)entryName, entryValue)).forEach(registryPiece -> registryPiece.onRegistryEvent((ResourceLocation)entryName, entryValue)));
    }

    @Override
    public void init() {
        super.init();
        this.entries.forEach((entryName, entryValue) -> this.registryPieces.stream().filter(registryPiece -> registryPiece.acceptsEntry((ResourceLocation)entryName, entryValue)).forEach(registryPiece -> registryPiece.init((ResourceLocation)entryName, entryValue)));
    }

    @Override
    public void onModelRun() {
        super.onModelRun();
        this.entries.forEach((entryName, entryValue) -> this.registryPieces.stream().filter(registryPiece -> registryPiece.acceptsEntry((ResourceLocation)entryName, entryValue)).forEach(registryPiece -> registryPiece.onModelEvent((ResourceLocation)entryName, entryValue)));
    }

    @Override
    public void postInit() {
        super.postInit();
        this.entries.forEach((entryName, entryValue) -> this.registryPieces.stream().filter(registryPiece -> registryPiece.acceptsEntry((ResourceLocation)entryName, entryValue)).forEach(registryPiece -> registryPiece.postInit((ResourceLocation)entryName, entryValue)));
    }

    @Override
    public void register(ResourceLocation name, ENTRY entry) {
        super.register(name, entry);
        this.registryPieces.stream().filter(registryPiece -> registryPiece.acceptsEntry(name, entry)).forEach(registryPiece -> registryPiece.addEntry(name, entry));
    }
}

